/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.xml;

import com.bmc.ctmconvert.common.xml.XmlElement;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlWriter {
    private Node root;
    private Document doc;

    public XmlWriter(Element root) {
        DocumentBuilder builder;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.doc = builder.newDocument();
        this.doc.importNode(root, true);
        this.root = root;
    }

    public void addElementsToRoot(List<XmlElement> elements) {
        elements.forEach(element -> {
            Element rbcElement = (Element)this.root.getOwnerDocument().importNode(element.getElement(), true);
            this.root.appendChild(rbcElement);
        });
    }

    public void writeXml(Writer writer) {
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            StringReader stringReader = new StringReader("<xsl:stylesheet version=\"1.0\"\r\nxmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\r\n<xsl:output method=\"xml\" omit-xml-declaration=\"yes\"/>\r\n<xsl:strip-space elements=\"*\"/>\r\n<xsl:template match=\"@*|node()\">\r\n<xsl:copy>\r\n<xsl:apply-templates select=\"@*|node()\"/>\r\n</xsl:copy></xsl:template>\r\n</xsl:stylesheet>");
            Transformer transformer = tf.newTransformer(new StreamSource(stringReader));
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(this.root), new StreamResult(writer));
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

