/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.xml;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlLoader {
    Document doc;
    String errormessage = "";
    private DocumentBuilder parser;

    public XmlLoader() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.parser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void loadFile(InputStream inputStream) throws IOException, SAXException {
        this.parse(inputStream);
    }

    public void loadFile(InputStream inputStream, String encoding) throws IOException, SAXException {
        this.parseByDefault(inputStream, encoding);
    }

    public Document parse(InputStream inputStream) throws SAXException, IOException {
        InputSource is = new InputSource(inputStream);
        String encodingProperty = SettingsTable.instance().getProperty(SettingsStringKeys.XML_ENCODING_VALUE);
        String xmlEncodingValue = encodingProperty.equals("") ? null : encodingProperty;
        is.setEncoding(xmlEncodingValue);
        this.doc = this.parser.parse(is);
        return this.doc;
    }

    public Document parseByDefault(InputStream inputStream, String encoding) throws SAXException, IOException {
        InputSource is = new InputSource(inputStream);
        is.setEncoding(encoding);
        this.doc = this.parser.parse(is);
        return this.doc;
    }

    public XmlElement getXmlElement() {
        if (this.doc != null) {
            return new XmlElement(this.doc.getDocumentElement());
        }
        return null;
    }

    public String getErrorMessage() {
        return this.errormessage;
    }

    public static XmlElement from(String xmlString) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8));
        return XmlLoader.from(inputStream);
    }

    public static XmlElement from(String xmlString, String encode) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8));
        return XmlLoader.from(inputStream, encode);
    }

    public static XmlElement from(InputStream input) {
        XmlLoader loader;
        try {
            loader = new XmlLoader();
            loader.loadFile(input);
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
        return loader.getXmlElement();
    }

    public static XmlElement from(InputStream input, String encode) {
        XmlLoader loader;
        try {
            loader = new XmlLoader();
            loader.loadFile(input, encode);
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
        return loader.getXmlElement();
    }
}

