/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.transformer.workspaces;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.message.IMessage;
import com.bmc.ctmconvert.common.message.MessageHandler;
import com.bmc.ctmconvert.common.message.NullMessageHandler;
import com.bmc.ctmconvert.common.transformer.sched_entities.DummyJob;
import com.bmc.ctmconvert.common.transformer.sched_entities.SmartFolder;
import com.bmc.ctmconvert.common.transformer.sched_entities.SubFolder;
import com.bmc.ctmconvert.common.transformer.sched_entities.WorkspaceSchedEntity;
import com.bmc.ctmconvert.common.transformer.workspaces.Folder;
import com.bmc.ctmconvert.common.transformer.workspaces.Job;
import com.bmc.ctmconvert.common.transformer.workspaces.Workspace;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspacePath;
import dependencies.DependencyAdapter;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public abstract class WorkspaceEntity {
    private final int id;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();
    private final Map<String, String> autoEdits = new LinkedHashMap<String, String>();
    private final List<Properties> rbcs = new ArrayList<Properties>();
    protected final Workspace workSpace;
    private MessageHandler messageHandler = new NullMessageHandler();
    public static final String TYPE_JOB = "Job";
    public static final String TYPE_FOLDER = "Folder";

    public abstract String type();

    public WorkspaceEntity(Workspace workSpace, String name, int id) {
        this.workSpace = workSpace;
        this.attributes.put("JOBNAME", name);
        this.id = id;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ControlMEntity [name=" + this.getName() + "]\n");
        for (String key : this.attributes.keySet()) {
            b.append(key).append(" - ").append(this.attributes.get(key)).append("\n");
        }
        if (!this.autoEdits.isEmpty()) {
            b.append("Variables:\n");
            for (String key : this.autoEdits.keySet()) {
                b.append(key).append(" - ").append(this.autoEdits.get(key)).append("\n");
            }
        }
        return b.toString();
    }

    public SchedEntity getSchedEntity() {
        WorkspaceSchedEntity workspaceSchedEntity;
        WorkspaceEntity workspaceEntity = this;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Folder.class, Folder.class, Job.class}, (Object)workspaceEntity, n)) {
                case 0: {
                    Folder folder = (Folder)workspaceEntity;
                    if (this.hasParent()) {
                        n = 1;
                        continue block5;
                    }
                    workspaceSchedEntity = new SmartFolder(folder);
                    break block5;
                }
                case 1: {
                    Folder folder = (Folder)workspaceEntity;
                    workspaceSchedEntity = new SubFolder(folder);
                    break block5;
                }
                case 2: {
                    Job job = (Job)workspaceEntity;
                    workspaceSchedEntity = new DummyJob(job);
                    break block5;
                }
                default: {
                    throw new RuntimeException("Unrecognized Control-M Entity type: " + String.valueOf(this));
                }
            }
            break;
        }
        return workspaceSchedEntity;
    }

    public Integer getId() {
        return this.id;
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public String getName() {
        return this.attributes.get("JOBNAME");
    }

    public LinkedHashMap<String, String> getAutoEditsList() {
        return new LinkedHashMap<String, String>(this.autoEdits);
    }

    public String getAutoEdit(String varName) {
        return this.autoEdits.getOrDefault(varName, "");
    }

    public void addAutoEdit(String name, String value) {
        this.autoEdits.put(name, value);
    }

    public void addScheduling(Properties rbc) {
        Folder parent;
        if (!this.containsRbc(rbc)) {
            this.rbcs.add(rbc);
        }
        if ((parent = this.getParent()) != null) {
            parent.addScheduling(rbc);
        }
    }

    private boolean containsRbc(Properties rbc) {
        return this.rbcs.contains(rbc);
    }

    public List<Properties> getScheduling() {
        return this.rbcs;
    }

    public void addAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public void addAttributes(Map<String, String> attrMap) {
        attrMap.forEach(this::addAttribute);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Optional<String> getAttribute(String attributeKey) {
        return Optional.ofNullable(this.attributes.get(attributeKey));
    }

    public List<DependencyAdapter> getAllDependencyList() {
        return this.workSpace.getAllDependenciesOf(this);
    }

    public Folder getParent() {
        return this.workSpace.getParentOf(this);
    }

    public WorkspacePath getPath() {
        return this.workSpace.getParentsPathOf(this);
    }

    public List<String> getMessages() {
        return this.workSpace.getJobMesages(this);
    }

    public void addMessage(String messageId, String ... params) {
        this.messageHandler.handleMessage(messageId, params);
    }

    public void addMessage(IMessage message) {
        this.workSpace.addMessage(this, message.getMessage());
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }
}

