/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.transformer.workspaces;

import com.bmc.ctmconvert.common.transformer.workspaces.Folder;
import com.bmc.ctmconvert.common.transformer.workspaces.Job;
import com.bmc.ctmconvert.common.transformer.workspaces.Workspace;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspaceEntity;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspacePath;
import dependencies.DependencyAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OnMemoryWorkspace
implements Workspace {
    private final Map<Integer, WorkspaceEntity> idToEntityMap = new HashMap<Integer, WorkspaceEntity>();
    private final List<WorkspaceEntity> folders = new ArrayList<WorkspaceEntity>();
    private final List<WorkspaceEntity> jobs = new ArrayList<WorkspaceEntity>();
    private int controlMEntityCounter = 0;
    private final Map<Folder, List<WorkspaceEntity>> parentToChildren = new HashMap<Folder, List<WorkspaceEntity>>();
    private final Map<WorkspaceEntity, Folder> childToParent = new HashMap<WorkspaceEntity, Folder>();
    private final Map<WorkspaceEntity, List<String>> messagesMap = new HashMap<WorkspaceEntity, List<String>>();
    private final List<DependencyAdapter> dependenciesList = new ArrayList<DependencyAdapter>();

    private void storeFolder(Folder folder) {
        this.folders.add(folder);
        this.storeEntity(folder);
    }

    private void storeJob(Job job) {
        this.jobs.add(job);
        this.storeEntity(job);
    }

    private void storeEntity(WorkspaceEntity entity) {
        Integer id = entity.getId();
        if (this.idToEntityMap.containsKey(id)) {
            throw new EntityAllreadyExistException(id);
        }
        this.idToEntityMap.put(id, entity);
    }

    @Override
    public void insertChildToParent(int childId, int parentId) {
        Folder localParent;
        try {
            localParent = this.getFolder(parentId);
        }
        catch (NotFolderException e) {
            throw new CreateHirarchyException(childId, parentId);
        }
        WorkspaceEntity localChild = this.getEntity(childId);
        if (localChild.hasParent()) {
            throw new ChildAlreadyHasParentException(childId);
        }
        this.childToParent.put(localChild, localParent);
        if (!this.parentToChildren.containsKey(localParent)) {
            this.parentToChildren.put(localParent, new ArrayList());
        }
        this.parentToChildren.get(localParent).add(localChild);
    }

    private Folder getFolder(int id) throws NotFolderException {
        WorkspaceEntity entity = this.getEntity(id);
        if (!(entity instanceof Folder)) {
            throw new NotFolderException(id);
        }
        return (Folder)entity;
    }

    private WorkspaceEntity getEntity(int id) {
        if (!this.idToEntityMap.containsKey(id)) {
            throw new EntityNotExistException(id);
        }
        return this.idToEntityMap.get(id);
    }

    @Override
    public List<Integer> getTopLevelEnteties() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (WorkspaceEntity folder : this.folders) {
            if (folder.hasParent()) continue;
            ret.add(folder.getId());
        }
        return ret;
    }

    @Override
    public boolean isFolder(int entId) {
        if (!this.idToEntityMap.containsKey(entId)) {
            return false;
        }
        WorkspaceEntity entity = this.idToEntityMap.get(entId);
        return entity instanceof Folder;
    }

    @Override
    public WorkspaceEntity getEntityById(Integer id) {
        return this.getEntity(id);
    }

    @Override
    public void addAttribute(Integer id, String key, String value) {
        WorkspaceEntity t = this.getEntity(id);
        t.addAttribute(key, value);
    }

    @Override
    public Folder getParentOf(WorkspaceEntity controlMEntity) {
        return this.childToParent.get(controlMEntity);
    }

    @Override
    public List<WorkspaceEntity> getChildrenOf(Folder folder) {
        ArrayList<WorkspaceEntity> ret = new ArrayList<WorkspaceEntity>();
        if (this.parentToChildren.containsKey(folder)) {
            ret.addAll((Collection<WorkspaceEntity>)this.parentToChildren.get(folder));
        }
        return ret;
    }

    @Override
    public WorkspacePath getParentsPathOf(WorkspaceEntity controlMEntity) {
        WorkspacePath ret = new WorkspacePath();
        ArrayList<String> parentsList = new ArrayList<String>();
        Folder parent = this.childToParent.get(controlMEntity);
        while (parent != null) {
            parentsList.add(parent.getName());
            parent = this.childToParent.get(parent);
        }
        Collections.reverse(parentsList);
        for (String name : parentsList) {
            ret.add(name);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Folders:\n");
        for (WorkspaceEntity folder : this.folders) {
            sb.append(folder).append(",");
        }
        sb.append("Jobs:\n");
        for (WorkspaceEntity job : this.jobs) {
            sb.append(job).append(",");
        }
        return sb.toString();
    }

    @Override
    public Folder createFolder(String folderName) {
        int folderId = this.createUniqeId();
        Folder folder = new Folder(this, folderName, folderId);
        this.storeFolder(folder);
        return folder;
    }

    public int createUniqeId() {
        return ++this.controlMEntityCounter;
    }

    @Override
    public Job createJob(String jobName) {
        int jobId = this.createUniqeId();
        Job newJob = new Job(jobName, jobId, this);
        this.storeJob(newJob);
        return newJob;
    }

    @Override
    public void addMessage(WorkspaceEntity ctmEntity, String message) {
        if (!this.messagesMap.containsKey(ctmEntity)) {
            this.messagesMap.put(ctmEntity, new ArrayList());
        }
        this.messagesMap.get(ctmEntity).add(message);
    }

    public ArrayList<String> getJobMesages(WorkspaceEntity controlMEntity) {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.messagesMap.containsKey(controlMEntity)) {
            ret.addAll((Collection<String>)this.messagesMap.get(controlMEntity));
        }
        return ret;
    }

    @Override
    public void addDependency(DependencyAdapter dependencyAdapter) {
        this.dependenciesList.add(dependencyAdapter);
    }

    @Override
    public List<DependencyAdapter> getAllDependenciesOf(WorkspaceEntity workspaceEntity) {
        ArrayList<DependencyAdapter> ret = new ArrayList<DependencyAdapter>();
        for (DependencyAdapter dependency : this.dependenciesList) {
            if (!workspaceEntity.getId().equals(dependency.getEntityA().getId()) && !workspaceEntity.getId().equals(dependency.getEntityB().getId())) continue;
            ret.add(dependency);
        }
        return ret;
    }

    public static class EntityAllreadyExistException
    extends RuntimeException {
        private static final long serialVersionUID = 6167046854039394131L;

        public EntityAllreadyExistException(int parentId) {
            super("id " + parentId + " not exist ");
        }
    }

    public static class NotFolderException
    extends Exception {
        private static final long serialVersionUID = -8361489201014779316L;

        public NotFolderException(int id) {
            super("id: " + id + ", not a folder");
        }
    }

    public static class CreateHirarchyException
    extends RuntimeException {
        private static final long serialVersionUID = -6709302316770301959L;

        public CreateHirarchyException(int childId, int parentId) {
            super("cannot insert id " + childId + " to " + parentId + ",id " + parentId + " is not a folder.cannot insert ");
        }
    }

    public static class ChildAlreadyHasParentException
    extends RuntimeException {
        private static final long serialVersionUID = 98258139114290384L;

        public ChildAlreadyHasParentException(int childId) {
            super("id " + childId + "already has parent");
        }
    }

    public static class EntityNotExistException
    extends RuntimeException {
        private static final long serialVersionUID = -4860883857443668300L;

        public EntityNotExistException(int childId) {
            super("id: " + childId + ", not exist");
        }
    }
}

