/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.transformer.sched_entities;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.conditions.Condition;
import com.bmc.ctmconvert.common.conditions.InCondition;
import com.bmc.ctmconvert.common.conditions.OutCondition;
import com.bmc.ctmconvert.common.conditions.Sign;
import com.bmc.ctmconvert.common.transformer.sched_entities.DefaultSchedEntity;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspaceEntity;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspacePath;
import com.bmc.ctmconvert.ondo.Do;
import com.bmc.ctmconvert.ondo.DoCondition;
import com.bmc.ctmconvert.ondo.OnStatement;
import dependencies.DependencyAdapter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;

public class WorkspaceSchedEntity
extends DefaultSchedEntity {
    protected final WorkspaceEntity entity;
    private final List<Properties> deleteOutConditionList = new ArrayList<Properties>();

    public WorkspaceSchedEntity(WorkspaceEntity entity, SchedEntity.TYPE type) {
        super(entity.getName(), type);
        this.entity = entity;
        entity.getAttributes().forEach((x$0, x$1) -> super.addAttribute((String)x$0, (String)x$1));
    }

    @Override
    public LinkedHashMap<String, String> getAutoedits() {
        return this.entity.getAutoEditsList();
    }

    @Override
    public List<Properties> getTags() {
        return new ArrayList<Properties>(this.entity.getScheduling());
    }

    @Override
    public List<Properties> getInConds() {
        ArrayList<Properties> inConditions = new ArrayList<Properties>();
        List<DependencyAdapter> dependencies = this.entity.getAllDependencyList();
        for (DependencyAdapter dependency : dependencies) {
            if (!this.isInCondition(dependency)) continue;
            InCondition inCondition = new InCondition(dependency.getConditionName(), "AND", "ODAT");
            this.addToList(inConditions, inCondition);
            if (!dependency.isAddDeleteCond()) continue;
            OutCondition outCondition = new OutCondition(dependency.getConditionName(), "ODAT", Sign.Remove);
            this.deleteOutConditionList.add(outCondition.getProperties());
        }
        return inConditions;
    }

    private boolean isInCondition(DependencyAdapter dependency) {
        return this.entity.getId().equals(dependency.getEntityB().getId());
    }

    @Override
    public List<Properties> getOutConds() {
        ArrayList<Properties> outList = new ArrayList<Properties>(this.deleteOutConditionList);
        List<DependencyAdapter> dependentyList = this.entity.getAllDependencyList();
        for (DependencyAdapter dependency : dependentyList) {
            if (!this.isOutCondition(dependency)) continue;
            OutCondition outCondition = new OutCondition(dependency.getConditionName(), "ODAT", Sign.Add);
            this.addToList(outList, outCondition);
        }
        return outList;
    }

    private void addToList(List<Properties> condList, Condition condition) {
        boolean toAddCond = true;
        for (Properties cond : condList) {
            if (!cond.getProperty("NAME").equals(condition.getName())) continue;
            toAddCond = false;
        }
        if (toAddCond) {
            condList.add(condition.getProperties());
        }
    }

    private boolean isOutCondition(DependencyAdapter dependency) {
        return this.entity.getId().equals(dependency.getEntityA().getId()) && dependency.getRelationType().equals("OUT_COND");
    }

    @Override
    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        LinkedHashMap<Properties, List<Properties>> onDoList = new LinkedHashMap<Properties, List<Properties>>();
        List<DependencyAdapter> dependentyList = this.entity.getAllDependencyList();
        OnStatement.OnNotOkStatement onNotOk = OnStatement.createOnNotOkStatement();
        for (DependencyAdapter dependency : dependentyList) {
            if (!this.isOnDoCondition(dependency)) continue;
            DoCondition doCondiotn = Do.createDoCondition(dependency.getConditionName(), DoCondition.AddRemoveSign.ADD);
            if (dependency.isEnded_OK_Status()) continue;
            onNotOk.addDo(doCondiotn);
            OnStatement.addOnToOnMap(onDoList, onNotOk);
        }
        return onDoList;
    }

    private boolean isOnDoCondition(DependencyAdapter dependency) {
        return this.entity.getId().equals(dependency.getEntityA().getId()) && dependency.getRelationType().equals("ON_DO_COND");
    }

    @Override
    public String getParentName() {
        WorkspacePath path = this.entity.getPath();
        return path.getAbsolutPath();
    }

    @Override
    public ArrayList<String> getMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.entity.getMessages() != null) {
            messages.addAll(this.entity.getMessages());
        }
        return messages;
    }

    @Override
    public boolean hasMessages() {
        List<String> messages = this.entity.getMessages();
        return messages != null && !messages.isEmpty();
    }

    @Override
    public boolean hasWarnings() {
        List<String> messages = this.entity.getMessages();
        return messages != null && !messages.isEmpty();
    }

    @Override
    public String getOriginalJobName() {
        return this.entity.getName();
    }
}

