/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.rbc.monthly;

import com.bmc.ctmconvert.common.exceptions.RBCIllegalValueException;
import com.bmc.ctmconvert.common.rbc.Calendarable;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.common.rbc.monthly.AbstractMonthlyRbc;
import com.bmc.ctmconvert.common.rbc.monthly.MonthlyRbc;
import java.util.List;
import java.util.Optional;

public class MonthlyCalendarBasedRbc
extends AbstractMonthlyRbc
implements Calendarable {
    public static final String RBC_NAME = "Based On Calendar";

    public MonthlyCalendarBasedRbc(String calendarName) {
        super("Based On Calendar " + calendarName);
        this.rbc.setDayscal(calendarName);
    }

    @Override
    public void addDay(MonthlyRbc.DayFromBegin day) {
        try {
            if (day != null) {
                MonthlyRbc.Day dayEnum = day.getDay();
                this.rbc.addDay(RBC.DAY_TYPE.WORKINGDAY, dayEnum.getValue());
            }
        }
        catch (RBCIllegalValueException rBCIllegalValueException) {
            // empty catch block
        }
    }

    @Override
    public List<MonthlyRbc.MonthDay> getDays() {
        List<MonthlyRbc.MonthDay> ret = super.getDaysFromEnd();
        List<Integer> dayList = this.rbc.getDaysList(RBC.DAY_TYPE.WORKINGDAY);
        for (Integer dayInteger : dayList) {
            Optional<MonthlyRbc.DayFromBegin> day = MonthlyRbc.DayFromBegin.FromInteger(dayInteger);
            day.ifPresent(ret::add);
        }
        return ret;
    }

    @Override
    public void setCalendar(String calendarName) {
        this.rbc.setDayscal(calendarName);
    }

    @Override
    public String getCalendar() {
        return this.rbc.getDayscal();
    }
}

