/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.rbc.monthly;

import com.bmc.ctmconvert.common.exceptions.RBCIllegalValueException;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.common.rbc.monthly.MonthlyRbc;
import com.bmc.ctmconvert.workspace.entities.AbstractRbc;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public abstract class AbstractMonthlyRbc
extends AbstractRbc
implements MonthlyRbc {
    public AbstractMonthlyRbc(String rbcName) {
        super(rbcName);
    }

    @Override
    public void addDayFromEnd(MonthlyRbc.DayFromEnd day) {
        try {
            if (day != null) {
                MonthlyRbc.Day dayEnum = day.getDay();
                this.rbc.addDay(RBC.DAY_TYPE.DAY_FROM_END, dayEnum.getValue());
            }
        }
        catch (RBCIllegalValueException rBCIllegalValueException) {
            // empty catch block
        }
    }

    public List<MonthlyRbc.MonthDay> getDaysFromEnd() {
        ArrayList<MonthlyRbc.MonthDay> ret = new ArrayList<MonthlyRbc.MonthDay>();
        List<Integer> daysFromEnd = this.rbc.getDaysList(RBC.DAY_TYPE.DAY_FROM_END);
        for (Integer dayInteger : daysFromEnd) {
            Optional<MonthlyRbc.DayFromEnd> day = MonthlyRbc.DayFromEnd.FromInteger(dayInteger);
            day.ifPresent(ret::add);
        }
        return ret;
    }

    @Override
    public void addMonth(RBC.MONTHS month) {
        this.rbc.addMonth(month);
    }

    @Override
    public void removeMonth(RBC.MONTHS month) {
        this.rbc.removeMonth(month);
    }

    @Override
    public void addAllMonths() {
        this.rbc.addAllMonths();
    }

    @Override
    public void removeAllMonths() {
        for (RBC.MONTHS month : RBC.MONTHS.values()) {
            this.rbc.removeMonth(month);
        }
    }

    @Override
    public List<RBC.MONTHS> getMonths() {
        return this.rbc.getMonths();
    }

    @Override
    public void addMonthByInterval(RBC.MONTHS startingFrom, MonthlyRbc.Interval interval) {
        for (int i = 0; i < RBC.MONTHS.values().length; i += interval.getValue().intValue()) {
            RBC.MONTHS month = RBC.MONTHS.values()[(startingFrom.ordinal() + i) % 12];
            this.rbc.addMonth(month);
        }
    }
}

