/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.rbc;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.rbc.RBC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RbcNamer {
    private static final String OF_MONTH_SUFFIX = "_of_month";
    private static final String FROM_MONTH_END_SUFFIX = "FromMonthEnd";
    private static final String LAST_OF_MONTH = "Last_of_month";
    private static final String unableToName = "unableToName";
    public static final String EMPTY_RBC = "EMPTY_RBC";
    public static final String daily = "Everyday";
    private static String weekdaysStrValue;
    private static String weekendsStrValue;
    private static int MAX_RBC_NAME_LENGTH;

    public static boolean nameRbc(Properties rbc, String startDayOfTheWek) {
        return RbcNamer.nameRbc(rbc, startDayOfTheWek, "Mo_Tu_We_Th_Fr", "Sa_Su");
    }

    public static boolean nameRbc(Properties rbc, String startDayOfTheWek, String weekdaysStr, String weekendsStr) {
        boolean named;
        weekdaysStrValue = weekdaysStr;
        weekendsStrValue = weekendsStr;
        String nameByWeekdays = RbcNamer.nameByWeekdays(rbc.getProperty("WEEKDAYS"), startDayOfTheWek);
        String nameByMonthDays = RbcNamer.nameByMonthDays(rbc.getProperty("DAYS"));
        String nameByMonths = RbcNamer.nameByMonths(rbc);
        String nameByClanedar = RbcNamer.nameByClanedar(rbc);
        Object simpleName = RbcNamer.suggestName(nameByWeekdays, nameByMonthDays, nameByMonths, nameByClanedar);
        Object exceptionName = RbcNamer.exceptionName(nameByWeekdays, nameByMonthDays, nameByMonths, nameByClanedar, rbc);
        if (RbcNamer.rbcContainShifting(rbc)) {
            String shiftValue = RbcNamer.getShiftValue(rbc);
            if (!((String)simpleName).isEmpty()) {
                simpleName = (String)simpleName + shiftValue;
            }
            if (!((String)exceptionName).isEmpty()) {
                exceptionName = (String)exceptionName + shiftValue;
            }
        }
        boolean bl = named = RbcNamer.setName(rbc, (String)simpleName) || RbcNamer.setName(rbc, (String)exceptionName) || RbcNamer.isEmptyRbc(rbc) && RbcNamer.setName(rbc, EMPTY_RBC);
        if (!named) {
            rbc.setProperty("NAME", "RBC_" + RbcNamer.rbcHashCode(rbc));
        }
        return named;
    }

    private static boolean isEmptyRbc(Properties rbc) {
        return rbc.getProperty("WEEKDAYS", "").isEmpty() && rbc.getProperty("DAYS", "").isEmpty() && rbc.getProperty("DAYSCAL", "").isEmpty() && rbc.getProperty("WEEKSCAL", "").isEmpty() && rbc.getProperty("CONFCAL", "").isEmpty();
    }

    private static String getShiftValue(Properties rbc) {
        String shiftNum = rbc.getProperty("SHIFTNUM");
        if (shiftNum.matches("[+-]0\\d")) {
            shiftNum = shiftNum.replaceAll("0", "");
        }
        return shiftNum;
    }

    private static boolean rbcContainShifting(Properties rbc) {
        return !rbc.getProperty("CONFCAL", "").isEmpty() && !rbc.getProperty("SHIFTNUM", "").isEmpty();
    }

    private static boolean setName(Properties rbc, String name) {
        boolean toRet = false;
        if (name.length() > MAX_RBC_NAME_LENGTH) {
            name = RbcNamer.shortenDaysAndMonths(name);
        }
        if (name.matches(String.format("[0-9a-zA-Z\\-_+]{1,%d}", MAX_RBC_NAME_LENGTH))) {
            rbc.setProperty("NAME", name);
            toRet = true;
        }
        return toRet;
    }

    public static String buildWeekdayStr(boolean[] weekdays) {
        String[] days = new String[]{"Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"};
        Object result = "";
        for (int index = 0; index < weekdays.length; ++index) {
            if (!weekdays[index]) continue;
            result = (String)result + days[index] + "_";
        }
        if (((String)result).length() > 0) {
            result = ((String)result).substring(0, ((String)result).length() - 1);
        }
        return result;
    }

    public static String shortenDaysAndMonths(String name) {
        TreeMap<String, String> replacements = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER){
            private static final long serialVersionUID = 1L;
            {
                this.put("Sunday", "Su");
                this.put("Monday", "Mo");
                this.put("Tuesday", "Tu");
                this.put("Wednesday", "We");
                this.put("Thursday", "Th");
                this.put("Friday", "Fr");
                this.put("Saturday", "Sa");
                this.put("January", "Jan");
                this.put("February", "Feb");
                this.put("March", "Mar");
                this.put("April", "Apr");
                this.put("May", "May");
                this.put("June", "Jun");
                this.put("July", "Jul");
                this.put("August", "Aug");
                this.put("September", "Sep");
                this.put("October", "Oct");
                this.put("November", "Nov");
                this.put("December", "Dec");
            }
        };
        String anyDayOrMonthRegexp = String.join((CharSequence)"|", replacements.keySet());
        StringBuffer result = new StringBuffer();
        Pattern anyDayOrMonth = Pattern.compile(anyDayOrMonthRegexp, 2);
        Matcher anyDayOrMonthMatcher = anyDayOrMonth.matcher(name);
        while (anyDayOrMonthMatcher.find()) {
            anyDayOrMonthMatcher.appendReplacement(result, (String)replacements.get(anyDayOrMonthMatcher.group()));
        }
        anyDayOrMonthMatcher.appendTail(result);
        return result.toString();
    }

    private static String suggestName(String nameByWeekdays, String nameByMonthDays, String nameByMonths, String nameByClanedar) {
        boolean nameable = true;
        if (nameByClanedar.equals(unableToName) || nameByMonthDays.equals(unableToName) || nameByMonths.equals(unableToName) || nameByWeekdays.equals(unableToName)) {
            nameable = false;
        }
        int nameCount = 0;
        if (!nameByClanedar.isEmpty()) {
            ++nameCount;
        }
        if (!nameByMonthDays.isEmpty()) {
            ++nameCount;
        }
        if (!nameByMonths.isEmpty()) {
            ++nameCount;
        }
        if (!nameByWeekdays.isEmpty()) {
            ++nameCount;
        }
        if (nameCount > 2 || nameCount == 0) {
            nameable = false;
        }
        String suggestedName = "";
        if (nameable) {
            if (!nameByClanedar.isEmpty()) {
                if (nameCount > 1) {
                    nameable = false;
                } else {
                    suggestedName = nameByClanedar;
                }
            } else if (!nameByMonths.isEmpty()) {
                if (!nameByMonthDays.isEmpty() && !nameByWeekdays.isEmpty()) {
                    nameable = false;
                } else {
                    suggestedName = !nameByMonthDays.isEmpty() ? nameByMonthDays.replace("month", nameByMonths) : (!nameByWeekdays.isEmpty() ? String.format("%s_%s", nameByMonths, nameByWeekdays) : nameByMonths);
                }
            } else if (nameCount == 2) {
                nameable = false;
            } else {
                suggestedName = nameByMonthDays != null && !nameByMonthDays.isEmpty() ? nameByMonthDays : nameByWeekdays;
            }
        }
        return suggestedName;
    }

    private static String exceptionName(String nameByWeekdays, String nameByMonthDays, String nameByMonths, String nameByClanedar, Properties rbc) {
        String suggestedName = "";
        if (nameByClanedar.isEmpty() || nameByClanedar.equals(unableToName)) {
            suggestedName = RbcNamer.nameByWeekdaysAndMonthDays(nameByMonths, nameByWeekdays, rbc.getProperty("DAYS"), rbc.getProperty("DAYS_AND_OR"));
        }
        return suggestedName;
    }

    private static String nameByClanedar(Properties rbc) {
        String daysCal = rbc.getProperty("DAYSCAL");
        String weeksCal = rbc.getProperty("WEEKSCAL");
        String confCal = rbc.getProperty("CONFCAL");
        String nameBy = "";
        if (daysCal != null && !daysCal.isEmpty()) {
            nameBy = "DAYSCAL";
        }
        if (weeksCal != null && !weeksCal.isEmpty()) {
            nameBy = nameBy.isEmpty() ? "WEEKSCAL" : unableToName;
        }
        if (confCal != null && !confCal.isEmpty()) {
            if (nameBy.isEmpty()) {
                String shift = rbc.getProperty("SHIFT", "NOCONFCAL");
                String shiftNum = rbc.getProperty("SHIFTNUM", "0");
                nameBy = shift.equals("NOCONFCAL") && shiftNum.matches("^[+\\-]0+$") ? "CONFCAL" : unableToName;
            } else {
                nameBy = unableToName;
            }
        }
        String toRet = nameBy;
        if (!nameBy.equals(unableToName) && !nameBy.isEmpty()) {
            toRet = rbc.getProperty(nameBy);
        }
        return toRet;
    }

    private static String nameByMonths(Properties rbc) {
        String[] months = GlobalFunctions.getMonthsArray();
        boolean singleMonth = false;
        String selectedMonth = "";
        boolean allMonths = true;
        for (int i = 0; i < months.length; ++i) {
            boolean bl = allMonths = allMonths && rbc.getProperty(months[i]).equals("1");
            if (!rbc.getProperty(months[i]).equals("1")) continue;
            singleMonth = selectedMonth.isEmpty();
            selectedMonth = months[i];
        }
        if (singleMonth) {
            return selectedMonth;
        }
        if (allMonths) {
            return "";
        }
        return unableToName;
    }

    private static String nameByModifiedMonthDays(String days) {
        String toRet = unableToName;
        if (days.toUpperCase().equals("L1")) {
            toRet = LAST_OF_MONTH;
        } else if (days.matches("^L[0-9]{1,2}(,L[0-9]{1,2})*$")) {
            ArrayList<Integer> daysArr = RbcNamer.stringToIntArr(days.replace("L", ""));
            toRet = RbcNamer.intArrToName(daysArr);
            toRet = toRet.replaceAll("_of_month$", FROM_MONTH_END_SUFFIX);
        }
        return toRet;
    }

    private static String nameByMonthDays(String monthDays) {
        String toRet = "";
        if (monthDays != null && !monthDays.isEmpty()) {
            if (monthDays.equalsIgnoreCase("ALL")) {
                toRet = daily;
            } else if (!monthDays.matches("^[0-9]{1,2}(,[0-9]{1,2})*$")) {
                toRet = RbcNamer.nameByModifiedMonthDays(monthDays);
            } else {
                ArrayList<Integer> monthDaysIntArr = RbcNamer.stringToIntArr(monthDays);
                Collections.sort(monthDaysIntArr);
                toRet = RbcNamer.intArrToName(monthDaysIntArr);
            }
        }
        return toRet;
    }

    public static ArrayList<Integer> stringToIntArr(String numList) {
        String[] monthDaysStrArr = numList.split("[,\\s]+");
        ArrayList<Integer> monthDaysIntArr = new ArrayList<Integer>();
        for (int i = 0; i < monthDaysStrArr.length; ++i) {
            Integer toAdd = Integer.valueOf(monthDaysStrArr[i]);
            if (monthDaysIntArr.contains(toAdd)) continue;
            monthDaysIntArr.add(toAdd);
        }
        return monthDaysIntArr;
    }

    private static String nameByWeekdaysAndMonthDays(String nameByMonths, String nameByWeekdays, String monthDays, String daysAndOr) {
        String toRet = "";
        if (monthDays != null && monthDays.matches("^L[1-7]{1}(,L[1-7]{1})*$") && nameByWeekdays != null && !nameByWeekdays.isEmpty()) {
            String[] monthDaysStrArr = monthDays.replace("L", "").split("[,\\s]+");
            boolean[] monthDaysBoolArr = new boolean[7];
            for (int i = 0; i < monthDaysStrArr.length; ++i) {
                monthDaysBoolArr[Integer.valueOf((String)monthDaysStrArr[i]).intValue() - 1] = true;
            }
            boolean isLastWeek = true;
            for (boolean day : monthDaysBoolArr) {
                isLastWeek &= day;
            }
            if (isLastWeek && daysAndOr.equals("AND")) {
                nameByMonths = ((String)nameByMonths).equals(unableToName) ? "" : (((String)nameByMonths).isEmpty() ? OF_MONTH_SUFFIX : "_of_" + (String)nameByMonths);
                toRet = String.format("Last_%s%s", nameByWeekdays, nameByMonths);
            }
        }
        return toRet;
    }

    private static String intArrToName(ArrayList<Integer> monthDaysIntArr) {
        Object toRet = "";
        if (monthDaysIntArr.size() == 1) {
            toRet = RbcNamer.presentableNumbers(monthDaysIntArr.get(0).toString());
        } else {
            ArrayList<String> ranges = new ArrayList<String>();
            for (int i = 0; i < monthDaysIntArr.size(); ++i) {
                int rangeStart;
                int rangeEnd = rangeStart = monthDaysIntArr.get(i).intValue();
                while (i + 1 < monthDaysIntArr.size() && monthDaysIntArr.get(i + 1) == monthDaysIntArr.get(i) + 1) {
                    rangeEnd = monthDaysIntArr.get(++i);
                }
                if (rangeEnd == rangeStart) {
                    ranges.add(String.format("%d", rangeEnd));
                    continue;
                }
                ranges.add(String.format("%d-%d", rangeStart, rangeEnd));
            }
            for (String range : ranges) {
                if (!((String)toRet).isEmpty()) {
                    toRet = (String)toRet + "_and_";
                }
                toRet = (String)toRet + RbcNamer.presentableNumbers(range);
            }
        }
        if (((String)toRet).length() + OF_MONTH_SUFFIX.length() < 20) {
            toRet = (String)toRet + OF_MONTH_SUFFIX;
        }
        return toRet;
    }

    private static String presentableNumbers(String input) {
        input = String.format("_%s_", input);
        input = input.replaceAll("([^1]1)([^0-9])", "$1st$2");
        input = input.replaceAll("([^1]2)([^0-9])", "$1nd$2");
        input = input.replaceAll("([^1]3)([^0-9])", "$1rd$2");
        input = input.replaceAll("([0-9])([_\\-\\s,])", "$1th$2");
        return input.substring(1, input.length() - 1);
    }

    private static String weekdayShortToShorter(String shortDay) {
        return shortDay.substring(0, 1).toUpperCase().concat(shortDay.substring(1, 2).toLowerCase());
    }

    private static String weekdayShortToLong(String shortDay) {
        if (shortDay.equalsIgnoreCase("sun")) {
            return "Sunday";
        }
        if (shortDay.equalsIgnoreCase("mon")) {
            return "Monday";
        }
        if (shortDay.equalsIgnoreCase("tue")) {
            return "Tuesday";
        }
        if (shortDay.equalsIgnoreCase("wed")) {
            return "Wednesday";
        }
        if (shortDay.equalsIgnoreCase("thu")) {
            return "Thursday";
        }
        if (shortDay.equalsIgnoreCase("fri")) {
            return "Friday";
        }
        if (shortDay.equalsIgnoreCase("sat")) {
            return "Saturday";
        }
        return unableToName;
    }

    private static String nameByWeekdays(String weekdays, String startDayOfTheWeek) {
        if (weekdays == null || weekdays.isEmpty()) {
            return "";
        }
        if (weekdays.equals("ALL")) {
            return daily;
        }
        if (!weekdays.matches("[0-6](,[0-6])*")) {
            return unableToName;
        }
        String[] daysArr = weekdays.split(",");
        Object dayList = "";
        for (int i = 0; i < daysArr.length; ++i) {
            if (!((String)dayList).isEmpty()) {
                dayList = (String)dayList + ",";
            }
            dayList = (String)dayList + GlobalFunctions.getWeekDaysArray(startDayOfTheWeek)[(Integer.valueOf(daysArr[i]) + 6) % 7];
        }
        daysArr = ((String)dayList).split(",");
        Object toRet = "";
        if (daysArr.length == 7) {
            toRet = daily;
        } else if (daysArr.length > 1) {
            for (int i = 0; i < daysArr.length; ++i) {
                if (!((String)toRet).isEmpty()) {
                    toRet = (String)toRet + "_";
                }
                toRet = (String)toRet + RbcNamer.weekdayShortToShorter(daysArr[i]);
            }
            if (weekdaysStrValue != null && ((String)toRet).equals(weekdaysStrValue)) {
                toRet = "Weekdays";
            }
            if (weekendsStrValue != null && ((String)toRet).equals(weekendsStrValue)) {
                toRet = "Weekends";
            }
        } else {
            toRet = RbcNamer.weekdayShortToLong((String)dayList);
        }
        return toRet;
    }

    private static String rbcHashCode(Properties rbc) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(rbc.getProperty("MAXWAIT", String.format("%02d", 0))).append(rbc.getProperty("DAYS_AND_OR", RBC.DAYS_AND_OR.OR.toString())).append(rbc.getProperty("DAYS", "")).append(rbc.getProperty("DAYSCAL", "")).append(rbc.getProperty("WEEKDAYS", "")).append(rbc.getProperty("WEEKSCAL", "")).append(rbc.getProperty("CONFCAL", "")).append(rbc.getProperty("SHIFT", RBC.SHIFT.IGNOREJOB.toString())).append(rbc.getProperty("SHIFTNUM", "0")).append(rbc.getProperty("ACTIVE_FROM", "19181111")).append(rbc.getProperty("ACTIVE_TILL", "19181111")).append(rbc.getProperty(RBC.MONTHS.JAN.toString(), "0")).append(rbc.getProperty(RBC.MONTHS.FEB.toString(), "0")).append(rbc.getProperty(RBC.MONTHS.MAR.toString(), "0")).append(rbc.getProperty(RBC.MONTHS.APR.toString(), "0")).append(rbc.getProperty(RBC.MONTHS.MAY.toString(), "0")).append(rbc.getProperty(RBC.MONTHS.JUN.toString(), "0")).append(rbc.getProperty(RBC.MONTHS.JUL.toString(), "0")).append(rbc.getProperty(RBC.MONTHS.AUG.toString(), "0")).append(rbc.getProperty(RBC.MONTHS.SEP.toString(), "0")).append(rbc.getProperty(RBC.MONTHS.OCT.toString(), "0")).append(rbc.getProperty(RBC.MONTHS.NOV.toString(), "0")).append(rbc.getProperty(RBC.MONTHS.DEC.toString(), "0"));
        return Integer.toString(stringBuilder.toString().hashCode(), 36);
    }

    static {
        MAX_RBC_NAME_LENGTH = 19;
    }
}

