/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.integration_factory.wrapper;

import com.bmc.ctmconvert.common.SchedEntity;

public class PeopleSoftWrapper {
    private final SchedEntity entity;
    private int variablesIndex;

    public PeopleSoftWrapper(SchedEntity entity) {
        this.entity = entity;
        this.variablesIndex = 1;
    }

    public PeopleSoftWrapper convert() {
        return this.convertDefaults();
    }

    public PeopleSoftWrapper withUserID(String userID) {
        this.entity.addAutoEdits("%%PS8-USERID", userID);
        this.entity.addAttribute("OWNER", userID);
        return this;
    }

    private PeopleSoftWrapper convertDefaults() {
        this.entity.addAttribute("TASKTYPE", "Job");
        this.entity.addAttribute("APPL_TYPE", "PS8");
        this.entity.addAttribute("APPL_FORM", "PEOPLESOFT");
        this.entity.addAttribute("APPL_VER", "9.0.0.000");
        this.entity.addAttribute("CM_VER", "N/A");
        this.entity.addAutoEdits("%%PS8-APOUT", "1");
        return this;
    }

    public PeopleSoftWrapper withRunControlId(String controlId) {
        this.entity.addAutoEdits("%%PS8-RUNCONTROLID", controlId);
        return this;
    }

    public PeopleSoftWrapper withJobName(String jobName) {
        this.entity.addAutoEdits("%%PS8-JOBNAME", jobName);
        return this;
    }

    public PeopleSoftWrapper withServer(String server) {
        this.entity.addAutoEdits("%%PS8-SERVERNAME", server);
        return this;
    }

    public PeopleSoftWrapper withProcessType(String type) {
        this.entity.addAutoEdits("%%PS8-PRCSTYPE", type);
        return this;
    }

    public PeopleSoftWrapper withConnectionProfile(String connectionProfileName) {
        this.entity.addAutoEdits("%%PS8-CON_PROFILE", connectionProfileName);
        return this;
    }

    public PeopleSoftWrapper withVariable(String value) {
        this.entity.addAutoEdits("%%PS8-USERDEF" + this.variablesIndex++, value);
        return this;
    }

    public PeopleSoftWrapper withProcessName(String processName) {
        this.entity.addAutoEdits("%%PS8-PRCSNAME", processName);
        return this;
    }

    public PeopleSoftWrapper withAppendOutput(boolean value) {
        String shouldAppend = value ? "1" : "0";
        this.entity.addAutoEdits("%%PS8-APOUT", shouldAppend);
        return this;
    }
}

