/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.writers;

import com.bmc.ctmconvert.common.draftwriter.json.writers.JsonWriter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;

public class JacksonWriter
implements JsonWriter {
    private final ObjectMapper objectMapper = new ObjectMapper();
    public static final Pattern ESCAPE_CONTROL_CHARACTERS = Pattern.compile("(\\\\)+(r|n|t)");

    public JacksonWriter() {
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    @Override
    public void toJson(Object src, Writer writer) throws IOException {
        writer.write(this.replaceControlCharactersInSource(src));
    }

    private String replaceControlCharactersInSource(Object src) throws JsonProcessingException {
        String srcAsString = this.objectMapper.writeValueAsString(src);
        return ESCAPE_CONTROL_CHARACTERS.matcher(srcAsString).replaceAll("$1$1$2");
    }
}

