/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.scheduling;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.generated.json.models.base.BaseWhen;
import com.bmc.ctmconvert.generated.json.models.base.Month;
import com.bmc.ctmconvert.interfaces.AttributeGetter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class BaseWhenAdapter {
    protected void setEndDate(BaseWhen when, String actTill) {
        Optional<String> activeTill = Optional.ofNullable(actTill);
        activeTill.filter(act -> !act.isEmpty()).ifPresent(arg_0 -> ((BaseWhen)when).setEndDate(arg_0));
    }

    protected void setStartDate(BaseWhen when, String actFrom) {
        Optional<String> activeFrom = Optional.ofNullable(actFrom);
        activeFrom.filter(act -> !act.isEmpty()).ifPresent(arg_0 -> ((BaseWhen)when).setStartDate(arg_0));
    }

    protected void setWeekDaysCalendar(BaseWhen when, String week) {
        Optional<String> weekCal = Optional.ofNullable(week);
        weekCal.ifPresent(arg_0 -> ((BaseWhen)when).withWeekDaysCalendar(arg_0));
    }

    protected void setMonthDaysCalendar(BaseWhen when, String days) {
        Optional<String> daysCal = Optional.ofNullable(days);
        daysCal.ifPresent(arg_0 -> ((BaseWhen)when).withMonthDaysCalendar(arg_0));
    }

    protected void setMonths(BaseWhen when, AttributeGetter attrGetter) {
        ArrayList<Month> months = new ArrayList<Month>();
        Arrays.stream(Month.values()).forEach(month -> Optional.ofNullable(attrGetter.getAttr(month.name())).filter("1"::equals).ifPresent(mon -> months.add((Month)month)));
        if (months.isEmpty()) {
            months.add(Month.NONE);
        }
        if (this.isNotAllMonths(months)) {
            when.withMonths(months);
        }
    }

    private boolean isNotAllMonths(List<Month> months) {
        return months.size() < 12;
    }

    protected Optional<List<String>> getWeekDays(String weekStrs) {
        ArrayList weekDays = new ArrayList();
        Optional<String> weekDaysStr = Optional.ofNullable(weekStrs);
        Pattern numberPattern = Pattern.compile("(?<plusOrMinus>[-+]?)(?<fromStartOrEnd>[LD]?)(?<number>\\d+)(?<weekNumber>(W\\d+)?)");
        weekDaysStr.ifPresent(weekStr -> {
            if (weekStr.equals("NONE") || weekStr.equals("ALL")) {
                weekDays.add(weekStr);
            } else {
                String[] days = weekStr.split(",");
                Arrays.stream(days).forEach(day -> {
                    Matcher m = numberPattern.matcher((CharSequence)day);
                    if (m.find()) {
                        weekDays.add(this.convertSingleDayOfWeek(m));
                    }
                });
            }
        });
        return weekDays.isEmpty() ? Optional.empty() : Optional.of(weekDays);
    }

    private String convertSingleDayOfWeek(Matcher m) {
        String result = m.group("plusOrMinus") + m.group("fromStartOrEnd");
        result = m.group("fromStartOrEnd").isEmpty() ? result + BaseWhenAdapter.getWeekdayString(m) : (m.group("weekNumber").isEmpty() ? result + m.group("number") : result + BaseWhenAdapter.getWeekdayString(m) + m.group("weekNumber"));
        return result;
    }

    @NotNull
    private static String getWeekdayString(Matcher m) {
        return GlobalFunctions.convertCalendarDayOfWeekToWeekday(Integer.parseInt(m.group("number")) + 1, true).toUpperCase();
    }
}

