/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopBaseJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopOptionsFactory;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.BaseHadoopJob;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.HadoopOption;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.HadoopSparkPython;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class HadoopSparkPythonAdapter
extends HadoopBaseJobAdapter<HadoopSparkPython.Type> {
    private static final Pattern SPARK_OPTIONS_PATTERN = Pattern.compile("HDP-SPARK_OPTION-N([0-9]{3})-(NAME|VAL)");

    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariablesFromStr = this.getAllUsedVariablesInHadoopBasejob();
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getSparkScript()));
        Stream.ofNullable(this.getOptions()).forEach(option -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(option.toString())));
        return usedVariablesFromStr;
    }

    public HadoopSparkPythonAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
    }

    @Override
    protected BaseHadoopJob buildBaseHadoopJob() {
        return new HadoopSparkPython().withSparkScript(this.getSparkScript()).withSparkOptions(this.getOptions());
    }

    private List<HadoopOption> getOptions() {
        return new HadoopOptionsFactory().getOptions(this.getVariablesAdapter(), SPARK_OPTIONS_PATTERN);
    }

    @Override
    public HadoopSparkPython.Type getType() {
        return HadoopSparkPython.Type.JOB_HADOOP_SPARK_PYTHON;
    }
}

