/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariableWrapper;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariablesAdapter;
import com.bmc.ctmconvert.generated.json.models.base.BaseJob;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.BaseHadoopJob;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.Command;
import com.bmc.ctmconvert.generated.json.models.job_types.hadoop.PrePostCommands;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class HadoopBaseJobAdapter<T>
extends BaseJobAdapter<T> {
    private static final Pattern PRE_COMMAND_PATTERN = Pattern.compile("HDP-PRE_CMD_ACTION-N([0-9]{3})-(CMD|ARG)");
    private static final Pattern POST_COMMAND_PATTERN = Pattern.compile("HDP-POST_CMD_ACTION-N([0-9]{3})-(CMD|ARG)");
    private static final Pattern ARGUMENTS_PATTERN = Pattern.compile("HDP-SPARK-N([0-9]{3})-(ARG)");

    protected HadoopBaseJobAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
    }

    @Override
    protected BaseJob buildBaseJob() {
        return this.buildBaseHadoopJob().withConnectionProfile(this.getConnectionProfile()).withPreCommands(this.getPreCommand()).withPostCommands(this.getPostCommands()).withArguments(this.getArguments());
    }

    protected Set<String> getAllUsedVariablesInHadoopBasejob() {
        HashSet<String> usedVariablesFromStr = new HashSet<String>();
        ((List)Optional.ofNullable(this.getArguments()).orElse(new ArrayList())).forEach(arg -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr((String)arg)));
        this.getCommands(this.getPreCommand(), this.getPostCommands()).forEach(command -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(command.toString())));
        return usedVariablesFromStr;
    }

    private List<Command> getCommands(PrePostCommands preCommand, PrePostCommands postCommands) {
        return Stream.concat(Stream.ofNullable(preCommand), Stream.ofNullable(postCommands)).flatMap(x -> Stream.ofNullable(x.getCommands().stream())).flatMap(x -> x).collect(Collectors.toList());
    }

    protected abstract BaseHadoopJob buildBaseHadoopJob();

    private String getConnectionProfile() {
        return this.schedEntity.getVariable("%%HDP-ACCOUNT");
    }

    private String toArgument(List<VariableWrapper> variableWrappers) {
        return VariablesAdapter.getParameterFrom(variableWrappers, "ARG");
    }

    protected Pattern getArgumentsPattern() {
        return ARGUMENTS_PATTERN;
    }

    protected List<String> getArguments() {
        List<String> arguments = this.getVariablesAdapter().convertAutoEditsWithPattern(this.getArgumentsPattern(), this::toArgument);
        return arguments.isEmpty() ? null : arguments;
    }

    protected PrePostCommands getPostCommands() {
        return this.createPrePostCommand(POST_COMMAND_PATTERN, "%%HDP-POST_CMD_FAIL_JOB", false);
    }

    protected PrePostCommands getPreCommand() {
        return this.createPrePostCommand(PRE_COMMAND_PATTERN, "%%HDP-PRE_CMD_FAIL_JOB", true);
    }

    private PrePostCommands createPrePostCommand(Pattern commandPattern, String attribute, boolean defaultFailJobValue) {
        List<Command> commands = this.getVariablesAdapter().convertAutoEditsWithPattern(commandPattern, this::preCommandsFrom);
        Optional<Boolean> failJobOnCommandFailure = this.getFailJobOnCommandFailure(attribute);
        if (commands.isEmpty() && failJobOnCommandFailure.isEmpty()) {
            return null;
        }
        return new PrePostCommands().withCommands(commands.isEmpty() ? null : commands).withFailJobOnCommandFailure(failJobOnCommandFailure.orElse(defaultFailJobValue));
    }

    private Optional<Boolean> getFailJobOnCommandFailure(String attribute) {
        return Optional.ofNullable(this.schedEntity.getVariable(attribute)).map("1"::equals);
    }

    private Command preCommandsFrom(List<VariableWrapper> variableWrappers) {
        String command = VariablesAdapter.getParameterFrom(variableWrappers, "CMD");
        String argument = VariablesAdapter.getParameterFrom(variableWrappers, "ARG");
        return new Command().withAdditionalProperty(command, (Object)argument);
    }

    protected String getSparkScript() {
        return this.schedEntity.getVariable("%%HDP-SPARK_FULL_PATH_TO_PYTHON_SCRIPT");
    }
}

