/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter.database;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SchedEntityAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SchedEntityAdapterFactory;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.database.EmbeddedQueryJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.database.SQLAgentAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.database.SQLScriptJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.database.SSISJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.database.StoredProcedureJobAdapter;
import java.util.Optional;

public class DatabaseJobAdapterFactory {
    private DatabaseJobAdapterFactory() {
    }

    public static boolean isDatabaseJob(SchedEntity entity) {
        return "DATABASE".equals(entity.getAttr("APPL_TYPE"));
    }

    private static Optional<String> getJobType(SchedEntity entity) {
        return Optional.ofNullable(entity.getAutoedits()).map(variables -> (String)variables.get("%%DB-EXEC_TYPE"));
    }

    public static SchedEntityAdapter<?> createDatabaseJobAdapter(SchedEntity entity, SchedEntity parent) {
        String databaseType;
        return switch (databaseType = DatabaseJobAdapterFactory.getJobType(entity).orElse("")) {
            case "Open Query" -> new EmbeddedQueryJobAdapter(entity, parent);
            case "SQL Script" -> new SQLScriptJobAdapter(entity, parent);
            case "MSSQL Agent Job" -> new SQLAgentAdapter(entity, parent);
            case "SSIS Package" -> new SSISJobAdapter(entity, parent);
            case "Stored Procedure" -> new StoredProcedureJobAdapter(entity, parent);
            default -> SchedEntityAdapterFactory.convertUnsupportedEntityToDummy(entity, parent);
        };
    }
}

