/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseOsJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariablesAdapter;
import com.bmc.ctmconvert.generated.json.models.base.BaseOsJob;
import com.bmc.ctmconvert.generated.json.models.job_types.ScriptJob;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

public class ScriptJobAdapter
extends BaseOsJobAdapter<ScriptJob.Type> {
    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariablesFromStr = this.variablesAdapter.getUsedVariablesFromStr(this.getFileName());
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getPreCommand()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getPostCommand()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getOverridePath()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getFilePath()));
        ((List)Optional.ofNullable(this.getVariablesAdapter().getArguments()).orElse(new ArrayList())).forEach(arg -> usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr((String)arg)));
        return usedVariablesFromStr;
    }

    public ScriptJobAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
        this.getVariablesAdapter().setIgnoreVariables(this.ignoreArguments());
    }

    public Predicate<String> ignoreArguments() {
        return s -> VariablesAdapter.CTM_PARAM_PATTERN.matcher((CharSequence)s).matches();
    }

    @Override
    public ScriptJob.Type getType() {
        return ScriptJob.Type.JOB_SCRIPT;
    }

    @Override
    protected BaseOsJob buildBaseOsJob() {
        ScriptJob scriptJob = new ScriptJob().withFileName(this.getFileName()).withFilePath(this.getFilePath()).withArguments(this.getVariablesAdapter().getArguments());
        this.getOverridePath().ifPresent(arg_0 -> ((ScriptJob)scriptJob).setOverridePath(arg_0));
        return scriptJob;
    }

    private String getFilePath() {
        return this.schedEntity.getAttr("MEMLIB");
    }

    private String getFileName() {
        return this.schedEntity.getAttr("MEMNAME");
    }

    private Optional<String> getOverridePath() {
        return Optional.ofNullable(this.schedEntity.getAttr("OVERLIB"));
    }
}

