/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.JsonUtils;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariableWrapper;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariablesAdapter;
import com.bmc.ctmconvert.generated.json.models.base.BaseJob;
import com.bmc.ctmconvert.generated.json.models.job_types.HTTPHeader;
import com.bmc.ctmconvert.generated.json.models.job_types.IntegrationFactoryRestWebServicesJob;
import com.bmc.ctmconvert.generated.json.models.job_types.OutputHandling;
import com.bmc.ctmconvert.generated.json.models.job_types.URLParameter;
import com.bmc.ctmconvert.generated.json.models.job_types.WsRestBody;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IntegrationFactoryRestWebServicesJobAdapter
extends BaseJobAdapter<IntegrationFactoryRestWebServicesJob.Type> {
    private static final Pattern URL_PARAMETERS_PATTERN = Pattern.compile("UCM-URL_PARAMETERS_(KEY|VALUE)_([0-9]{3})");
    private static final Pattern HTTP_HEADERS_PATTERN = Pattern.compile("UCM-HEADERS_(KEY|VALUE)_([0-9]{3})");
    private static final Pattern OUTPUT_HANDELING_PARAMETERS_PATTERN = Pattern.compile("UCM-WS_OUTPUT_PARAMETERS_(HTTPCODE|VARIABLE|PARAM)_([0-9]{3})");
    private final VariablesAdapter innerVariablesAdapter = this.getVariablesAdapter().withGroupByIndex(this.getGroupBySecondIndex());

    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariablesFromStr = this.variablesAdapter.getUsedVariablesFromStr(this.getConnectionProfile());
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getConnectionTimeOut()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getEndpointUrl()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getUrlRequestPath()));
        return usedVariablesFromStr;
    }

    public IntegrationFactoryRestWebServicesJobAdapter(SchedEntity entity, SchedEntity parent) {
        super(entity, parent);
    }

    @Override
    protected BaseJob buildBaseJob() {
        return new IntegrationFactoryRestWebServicesJob().withConnectionProfile(this.getConnectionProfile()).withMethod(this.getMethod()).withConnectionTimeout(this.getConnectionTimeOut()).withAppendRequest(this.getAppendRequest()).withAppendResponse(this.getAppendResponse()).withEndpointURL(this.getEndpointUrl()).withURLRequestPath(this.getUrlRequestPath()).withWsRestBody(this.getRequestBody()).withURLParameters(this.getUrlParameters()).withHTTPHeaders(this.getHttpHeaders()).withOutputHandling(this.getOutputHandling());
    }

    private WsRestBody getRequestBody() {
        Optional<String> requestBody = Optional.ofNullable(this.schedEntity.getVariable("%%UCM-BODY_BODY_REQUEST"));
        return requestBody.map(body -> {
            WsRestBody.RequestDefinition requestBodyType = this.getRequestBodyType();
            return new WsRestBody().withBodyRequest(body).withRequestDefinition(requestBodyType);
        }).orElse(null);
    }

    private WsRestBody.RequestDefinition getRequestBodyType() {
        Optional<String> requestBodyType = Optional.ofNullable(this.schedEntity.getVariable("%%UCM-BODY_REQ_TYPE"));
        return requestBodyType.map(type -> switch (type) {
            case "filename" -> WsRestBody.RequestDefinition.FILENAME;
            case "text" -> WsRestBody.RequestDefinition.TEXT;
            default -> WsRestBody.RequestDefinition.NONE;
        }).orElse(WsRestBody.RequestDefinition.NONE);
    }

    private String getUrlRequestPath() {
        return this.schedEntity.getVariable("%%UCM-URL_REQUEST_PATH");
    }

    private String getEndpointUrl() {
        return this.schedEntity.getVariable("%%UCM-ENDPOINT_URL");
    }

    private IntegrationFactoryRestWebServicesJob.AppendResponse getAppendResponse() {
        if ("unchecked".equals(this.schedEntity.getVariable("%%UCM-APPEND_RESPONSE"))) {
            return IntegrationFactoryRestWebServicesJob.AppendResponse.UNCHECKED;
        }
        return IntegrationFactoryRestWebServicesJob.AppendResponse.CHECKED;
    }

    private IntegrationFactoryRestWebServicesJob.AppendRequest getAppendRequest() {
        if ("unchecked".equals(this.schedEntity.getVariable("%%UCM-APPEND_REQUEST"))) {
            return IntegrationFactoryRestWebServicesJob.AppendRequest.UNCHECKED;
        }
        return IntegrationFactoryRestWebServicesJob.AppendRequest.CHECKED;
    }

    private String getConnectionTimeOut() {
        return this.schedEntity.getVariable("%%UCM-CONN_TIMEOUT");
    }

    private String getConnectionProfile() {
        return this.schedEntity.getVariable("%%UCM-ACCOUNT");
    }

    private IntegrationFactoryRestWebServicesJob.Method getMethod() {
        Optional<String> method = Optional.ofNullable(this.schedEntity.getVariable("%%UCM-METHOD"));
        return method.map(m -> switch (m) {
            case "POST" -> IntegrationFactoryRestWebServicesJob.Method.POST;
            case "PUT" -> IntegrationFactoryRestWebServicesJob.Method.PUT;
            case "DELETE" -> IntegrationFactoryRestWebServicesJob.Method.DELETE;
            case "HEAD" -> IntegrationFactoryRestWebServicesJob.Method.HEAD;
            case "OPTIONS" -> IntegrationFactoryRestWebServicesJob.Method.OPTIONS;
            case "TRACE" -> IntegrationFactoryRestWebServicesJob.Method.TRACE;
            case "PATCH" -> IntegrationFactoryRestWebServicesJob.Method.PATCH;
            case "GET" -> IntegrationFactoryRestWebServicesJob.Method.GET;
            default -> null;
        }).orElse(IntegrationFactoryRestWebServicesJob.Method.GET);
    }

    private List<URLParameter> getUrlParameters() {
        return JsonUtils.getOrNull(this.innerVariablesAdapter.convertAutoEditsWithPattern(URL_PARAMETERS_PATTERN, this::urlParameterFrom));
    }

    private List<HTTPHeader> getHttpHeaders() {
        return JsonUtils.getOrNull(this.innerVariablesAdapter.convertAutoEditsWithPattern(HTTP_HEADERS_PATTERN, this::httpHeaderFrom));
    }

    private BiFunction<VariableWrapper, Pattern, String> getGroupBySecondIndex() {
        int SECOND_MATCHED_GROUP = 2;
        return (variable, pattern) -> {
            String variableName = variable.getKey();
            Matcher indexMatcher = pattern.matcher(variableName);
            return indexMatcher.matches() ? indexMatcher.group(2) : "";
        };
    }

    private URLParameter urlParameterFrom(List<VariableWrapper> variableWrappers) {
        return this.entityFrom(variableWrappers, (name, value) -> new URLParameter().withAdditionalProperty(name, value));
    }

    private HTTPHeader httpHeaderFrom(List<VariableWrapper> variableWrappers) {
        return this.entityFrom(variableWrappers, (name, value) -> new HTTPHeader().withAdditionalProperty(name, value));
    }

    private <T> T entityFrom(List<VariableWrapper> variableWrappers, BiFunction<String, String, T> constructor) {
        String name = IntegrationFactoryRestWebServicesJobAdapter.getParameterFrom(variableWrappers, "KEY");
        String value = IntegrationFactoryRestWebServicesJobAdapter.getParameterFrom(variableWrappers, "VALUE");
        return constructor.apply(name, value);
    }

    public static String getParameterFrom(List<VariableWrapper> variableNameAndValue, String attribute) {
        return variableNameAndValue.stream().filter(p -> p.getKey().contains(attribute)).map(VariableWrapper::getValue).findFirst().orElse("");
    }

    private OutputHandling outputHandlingFromm(List<VariableWrapper> variables) {
        Function<String, Optional> getVariable = pattern -> variables.stream().filter(x -> x.getKey().contains("UCM-WS_OUTPUT_PARAMETERS_" + pattern)).map(VariableWrapper::getValue).findFirst();
        Optional httpCode = getVariable.apply("HTTPCODE");
        Optional parameter = getVariable.apply("PARAM");
        Optional variable = getVariable.apply("VARIABLE");
        return httpCode.flatMap(code -> variable.flatMap(v -> parameter.map(parm -> new OutputHandling().withHttpCode(code).withVariable(v).withParameter(parm)))).orElse(null);
    }

    private List<OutputHandling> getOutputHandling() {
        return JsonUtils.getOrNull(this.innerVariablesAdapter.convertAutoEditsWithPattern(OUTPUT_HANDELING_PARAMETERS_PATTERN, this::outputHandlingFromm));
    }

    @Override
    public IntegrationFactoryRestWebServicesJob.Type getType() {
        return IntegrationFactoryRestWebServicesJob.Type.JOB_WEB_SERVICES_REST;
    }
}

