/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.DummyJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.SchedEntityAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopHiveJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopJavaMapReduceAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopPigJobAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopSparkJavaAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopSparkPythonAdapter;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.hadoop.HadoopSqoopJobAdapter;

public class HadoopJobAdapterFactory {
    private HadoopJobAdapterFactory() {
    }

    public static boolean isHadoopJob(SchedEntity entity) {
        return HadoopJobAdapterFactory.isHadoopApplicationType(entity);
    }

    private static boolean isHadoopApplicationType(SchedEntity entity) {
        return "HADOOP".equals(entity.getAttr("APPL_TYPE"));
    }

    public static SchedEntityAdapter<?> createHadoopJob(SchedEntity entity, SchedEntity parent) {
        if ("PYTHON".equals(HadoopJobAdapterFactory.getHadoopSparkProgramType(entity))) {
            return new HadoopSparkPythonAdapter(entity, parent);
        }
        if ("JAVA_AND_SCALA".equals(HadoopJobAdapterFactory.getHadoopSparkProgramType(entity))) {
            return new HadoopSparkJavaAdapter(entity, parent);
        }
        if ("HIVE".equals(HadoopJobAdapterFactory.getHadoopExecutionType(entity))) {
            return new HadoopHiveJobAdapter(entity, parent);
        }
        if ("PIG".equals(HadoopJobAdapterFactory.getHadoopExecutionType(entity))) {
            return new HadoopPigJobAdapter(entity, parent);
        }
        if ("SQOOP".equals(HadoopJobAdapterFactory.getHadoopExecutionType(entity))) {
            return new HadoopSqoopJobAdapter(entity, parent);
        }
        if ("MAP_REDUCE".equals(HadoopJobAdapterFactory.getHadoopExecutionType(entity))) {
            return new HadoopJavaMapReduceAdapter(entity, parent);
        }
        return new DummyJobAdapter(entity, parent);
    }

    private static String getHadoopExecutionType(SchedEntity entity) {
        return entity.getVariable("%%HDP-EXEC_TYPE");
    }

    private static String getHadoopSparkProgramType(SchedEntity entity) {
        return entity.getVariable("%%HDP-SPARK_PROG_TYPE");
    }
}

