/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.generated.json.models.base.EventDefinition;
import com.bmc.ctmconvert.generated.json.models.events.OpEvent;
import com.bmc.ctmconvert.generated.json.models.if_schema.actions.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;

public class EventDefinitionAdapter {
    private static final String ORDER_DATE = "OrderDate";
    private static final String ANY_DATE = "AnyDate";
    private static final String PREV = "PreviousOrderDate";
    private static final String NEXT = "NextOrderDate";
    private final EventDefinition.Type type;
    private final List<Properties> conditions;
    static final String CLOSE_BRACKET = ")";
    static final String OPEN_BRACKET = "(";
    static final String OR = "OR";

    public EventDefinitionAdapter(List<Properties> conditions, EventDefinition.Type type) {
        this.conditions = conditions;
        this.type = type;
    }

    private List<Object> getEvents() {
        return this.conditions.stream().filter(Objects::nonNull).map(this::createEvent).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<Object> createEvent(Properties properties) {
        return this.orderEventList(properties);
    }

    private String getOdat(Properties properties) {
        String odate;
        String dateType = ORDER_DATE;
        switch (odate = Optional.ofNullable(properties.getProperty("ODATE")).orElse(ORDER_DATE)) {
            case "NEXT": {
                dateType = NEXT;
                break;
            }
            case "PREV": {
                dateType = PREV;
                break;
            }
            case "****": 
            case "STAT": {
                dateType = ANY_DATE;
                break;
            }
            default: {
                if (!this.isMMDD(odate)) break;
                dateType = odate;
            }
        }
        return dateType;
    }

    private List<Object> orderEventList(Properties properties) {
        String odate = this.getOdat(properties);
        String op = Optional.ofNullable(properties.getProperty("OP")).orElse("");
        String andOr = Optional.ofNullable(properties.getProperty("AND_OR")).orElse("");
        return this.createOrderedEvents(properties, odate, op, andOr);
    }

    private List<Object> createOrderedEvents(Properties properties, String odate, String op, String andOr) {
        List<Object> eventList = new ArrayList<Event>();
        Event event = new Event().withEvent(properties.get("NAME").toString()).withDate(odate);
        if (op.equals(OPEN_BRACKET)) {
            eventList = this.addEventsToList(OpEvent.fromValue((String)op), event, andOr);
        } else if (op.equals(CLOSE_BRACKET)) {
            eventList = this.addEventsToList(event, OpEvent.fromValue((String)op), andOr);
        } else {
            eventList.add(event);
            if (andOr.equals(OR)) {
                eventList.add(OpEvent.fromValue((String)OR));
            }
        }
        return eventList;
    }

    private List<Object> addEventsToList(Object firstItem, Object secondItem, String andOr) {
        ArrayList<Object> eventsList = new ArrayList<Object>();
        eventsList.add(firstItem);
        eventsList.add(secondItem);
        if (andOr.equals("O")) {
            eventsList.add(OpEvent.fromValue((String)OR));
        }
        return eventsList;
    }

    private boolean isMMDD(String odate) {
        return GlobalFunctions.isValidDate(odate, "MMdd");
    }

    public EventDefinition getEventDefinition() {
        return new EventDefinition().withType(this.type).withEvents(this.getEvents());
    }
}

