/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseSchedEntityAdapter;
import com.bmc.ctmconvert.generated.json.models.base.BaseJob;
import com.bmc.ctmconvert.generated.json.models.base.BaseJsonObject;
import com.bmc.ctmconvert.generated.json.models.base.JobProperties;
import com.bmc.ctmconvert.generated.json.models.base.Output;
import java.util.Optional;

public abstract class BaseJobAdapter<T>
extends BaseSchedEntityAdapter<T> {
    public static final String DEFAULT_HELIX_HOST_GROUP = "DEFAULT_HOST_GROUP";

    protected BaseJobAdapter(SchedEntity schedEntity, SchedEntity parent) {
        super(schedEntity, parent);
    }

    protected abstract BaseJob buildBaseJob();

    @Override
    protected BaseJsonObject buildJobProperties() {
        BaseJob baseJob = this.buildBaseJob();
        baseJob.setName(this.getName());
        this.getHost().ifPresent(arg_0 -> ((BaseJob)baseJob).setHost(arg_0));
        this.getEndFolder().ifPresent(arg_0 -> ((BaseJob)baseJob).setEndFolder(arg_0));
        this.getRetroactive().ifPresent(arg_0 -> ((BaseJob)baseJob).setRetroactiveOrder(arg_0));
        this.getRunOnAllAgentsInGroup().ifPresent(arg_0 -> ((BaseJob)baseJob).setRunOnAllAgentsInGroup(arg_0));
        this.getOutput().ifPresent(arg_0 -> ((BaseJob)baseJob).setOutput(arg_0));
        this.jobPropertiesAdapter.getResourcesAdapter().addQuantitativeResources((JobProperties)baseJob);
        return baseJob;
    }

    private Optional<Boolean> getRunOnAllAgentsInGroup() {
        Boolean result = null;
        if ("Y".equals(this.schedEntity.getAttr("MULTY_AGENT"))) {
            result = true;
        } else if ("N".equals(this.schedEntity.getAttr("MULTY_AGENT"))) {
            result = false;
        }
        return Optional.ofNullable(result);
    }

    private Optional<String> getRetroactive() {
        return Optional.ofNullable(this.schedEntity.getAttr("RETRO"));
    }

    private Optional<Boolean> getEndFolder() {
        return Optional.ofNullable(this.schedEntity.getAttr("END_FOLDER")).map(endFolder -> endFolder.equals("Y"));
    }

    Optional<String> getHost() {
        Optional<String> hostGroup = Optional.ofNullable(this.schedEntity.getAttr("NODEID")).filter(host -> !host.isBlank());
        if (hostGroup.isEmpty()) {
            this.addMissingHostMessage(this.schedEntity);
        }
        return Optional.of(hostGroup.orElse(DEFAULT_HELIX_HOST_GROUP));
    }

    private Optional<Output> getOutput() {
        Optional<String> outputOption = Optional.ofNullable(this.schedEntity.getAttr("OPTION"));
        String outputPar = this.schedEntity.getAttr("PAR");
        return outputOption.map(option -> this.createOutput((String)option, outputPar));
    }

    private Output createOutput(String outputOption, String outputPar) {
        Output output = new Output().withOperation(this.convertOutputOption(outputOption));
        GlobalFunctions.ifPresent(outputPar, () -> output.setDestination(outputPar));
        return output;
    }

    private Output.Operation convertOutputOption(String outputOption) {
        if ("Release".equals(outputOption)) {
            return Output.Operation.PRINT;
        }
        return Output.Operation.fromValue((String)outputOption);
    }

    private void addMissingHostMessage(SchedEntity entity) {
        Reporter.addMessage(entity.getMessages(), "WRN0023", entity.getJobName(), Params.instance().getVendorName(), entity.getJobName(), DEFAULT_HELIX_HOST_GROUP, entity.getOriginalJobName());
    }
}

