/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseJobAdapter;
import com.bmc.ctmconvert.generated.json.models.base.BaseJob;
import com.bmc.ctmconvert.generated.json.models.job_types.AirflowJob;
import java.util.Optional;
import java.util.Set;

public class AirFlowJobAdapter
extends BaseJobAdapter<AirflowJob.Type> {
    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        Set<String> usedVariablesFromStr = this.variablesAdapter.getUsedVariablesFromStr(this.getDagId());
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getConnectionProfile()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getConfigurationJson()));
        usedVariablesFromStr.addAll(this.variablesAdapter.getUsedVariablesFromStr(this.getOutputDetail().value()));
        return usedVariablesFromStr;
    }

    public AirFlowJobAdapter(SchedEntity entity, SchedEntity parent) {
        super(entity, parent);
    }

    @Override
    protected BaseJob buildBaseJob() {
        return new AirflowJob().withDagId(this.getDagId()).withConnectionProfile(this.getConnectionProfile()).withConfigurationJson(this.getConfigurationJson()).withRerunFromPointOfFailure(Boolean.valueOf(this.getRerunFromPointOfFailure())).withOutputDetails(this.getOutputDetail());
    }

    private String getConfigurationJson() {
        return this.schedEntity.getVariable("%%AFL-CONF_JSON");
    }

    private AirflowJob.OutputDetails getOutputDetail() {
        return Optional.ofNullable(this.schedEntity.getVariable("%%AFL-OUTPUT_MODE")).map(v -> switch (v) {
            case "NO_TASKS" -> AirflowJob.OutputDetails.DO_NOT_INCLUDE_TASK_LOGS;
            case "ALL_TASKS" -> AirflowJob.OutputDetails.INCLUDE_ALL_TASKS_LOGS;
            default -> AirflowJob.OutputDetails.INCLUDE_ONLY_FAILED_TASKS_LOGS;
        }).orElse(AirflowJob.OutputDetails.INCLUDE_ONLY_FAILED_TASKS_LOGS);
    }

    private boolean getRerunFromPointOfFailure() {
        return Optional.ofNullable(this.schedEntity.getVariable("%%AFL-RERUN_POF")).map("True"::equalsIgnoreCase).orElse(false);
    }

    private String getConnectionProfile() {
        return Optional.ofNullable(this.schedEntity.getVariable("%%AFL-ACCOUNT")).orElse("DEFAULT_CONNECTION");
    }

    private String getDagId() {
        return this.schedEntity.getVariable("%%AFL-DAG_ID");
    }

    public static boolean isAirFlowJob(SchedEntity entity) {
        return "AFL".equals(entity.getAttr("APPL_TYPE")) && "Airflow".equals(entity.getAttr("APPL_FORM"));
    }

    @Override
    public AirflowJob.Type getType() {
        return AirflowJob.Type.JOB_AIRFLOW;
    }
}

