/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json;

import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.DataAccumulator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DataAccumulatorWrapper {
    private final DataAccumulator dataAccumulator;
    private int count;

    public DataAccumulatorWrapper(DataAccumulator dataAccumulator) {
        this.dataAccumulator = dataAccumulator;
        this.count = 0;
    }

    public void update(SchedEntity entity) {
        this.dataAccumulator.update(entity, this.incrementCounter());
        this.checkForDuplicatedResourceNames(entity);
        Optional<List<SchedEntity>> optionalChildren = Optional.ofNullable(entity.getChildren());
        optionalChildren.ifPresent(children -> {
            children.forEach(this::update);
            this.checkForDuplicatedJobNames((List<SchedEntity>)children);
        });
    }

    private void checkForDuplicatedJobNames(@NotNull List<SchedEntity> children) {
        boolean isThereDuplicatedJobName = children.stream().filter(SchedEntity::isJob).map(SchedEntity::getJobName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).values().stream().anyMatch(count -> count > 1L);
        if (isThereDuplicatedJobName) {
            Params.instance().enableDuplicatedJobNames();
        }
    }

    private void checkForDuplicatedResourceNames(@NotNull SchedEntity entity) {
        ArrayList resources = new ArrayList();
        Optional.ofNullable(entity.getCtrlResources()).ifPresent(resources::addAll);
        Optional.ofNullable(entity.getQuantResources()).ifPresent(resources::addAll);
        boolean isThereDuplicatedResourceName = resources.stream().map(res -> res.getProperty("NAME")).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).values().stream().anyMatch(count -> count > 1L);
        if (isThereDuplicatedResourceName) {
            Params.instance().enableDuplicatedResourceNames();
        }
    }

    private int incrementCounter() {
        return ++this.count;
    }

    public DataAccumulatorWrapper addGeneralMessages(List<String> messages) {
        this.dataAccumulator.addGeneralMessages(messages);
        return this;
    }
}

