/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter;

import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.JobConsumer;

public class EntitiesCounter
implements JobConsumer {
    private Integer createdJobsCount = 0;
    private Integer createdSubCount = 0;
    private Integer createdFoldersCount = 0;

    @Override
    public void update(SchedEntity job, int serial) {
        if (job.isValid()) {
            switch (job.type()) {
                case SMART_TABLE: 
                case TABLE: {
                    Integer n = this.createdFoldersCount;
                    this.createdFoldersCount = this.createdFoldersCount + 1;
                    break;
                }
                case SUB_TABLE: {
                    Integer n = this.createdSubCount;
                    this.createdSubCount = this.createdSubCount + 1;
                    break;
                }
                default: {
                    Integer n = this.createdJobsCount;
                    this.createdJobsCount = this.createdJobsCount + 1;
                }
            }
        }
    }

    @Override
    public void updateReporter(Reporter reporter) {
        reporter.setSmartTablesCreated(this.createdFoldersCount);
        reporter.setSubTablesCreated(this.createdSubCount);
        reporter.setJobsCreated(this.createdJobsCount);
    }

    public Integer getCreatedJobsCount() {
        return this.createdJobsCount;
    }

    public Integer getCreatedSubCount() {
        return this.createdSubCount;
    }

    public Integer getCreatedFoldersCount() {
        return this.createdFoldersCount;
    }
}

