/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter;

import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.ElementDescriptor;
import com.bmc.ctmconvert.common.draftwriter.VersionControl;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DraftFormat {
    private static DraftFormat instance;
    private static String loadedVersion;
    private VersionControl versionControl;
    private HashMap<FormatType, ElementDescriptor> formatMap;
    private Charset draftCharset;
    private BiFunction<Integer, String, String> descriptionValueHandler;

    public static DraftFormat instance() {
        if (!loadedVersion.equals(DraftFormat.getCurrentVersion())) {
            instance = null;
        }
        if (instance == null) {
            Charset draftCharset = DraftFormat.getDraftCharSet();
            instance = new DraftFormat(draftCharset);
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    public DraftFormat(Charset draftCharset, BiFunction<Integer, String, String> descriptionValueHandler) {
        this.descriptionValueHandler = descriptionValueHandler;
        this.draftCharset = draftCharset;
        loadedVersion = DraftFormat.getCurrentVersion();
        for (FormatType type : FormatType.values()) {
            if (this.formatMap == null) {
                this.formatMap = new HashMap();
            }
            this.formatMap.put(type, this.loadFormat(type.toString()));
        }
        this.applyOverrides();
    }

    public DraftFormat(Charset draftCharset) {
        this(draftCharset, null);
    }

    public static String getFormatDir() {
        return String.format("%s%sformats%s", Globs.DATA_DIR, Globs.DIRSEP, Globs.DIRSEP);
    }

    private ElementDescriptor loadFormat(String jobFormatFileName) {
        LinkedHashMap<String, ArrayList<String>> eMap = new LinkedHashMap<String, ArrayList<String>>();
        File entFormatFile = new File(String.format("%s%s.txt", DraftFormat.getFormatDir(), jobFormatFileName));
        try (BufferedReader br = new BufferedReader(new FileReader(entFormatFile));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.matches("^\\s*#.*") || line.trim().isEmpty()) continue;
                String[] lineArr = line.trim().split("\\s+", 2);
                if (!eMap.containsKey(lineArr[0])) {
                    eMap.put(lineArr[0], new ArrayList());
                }
                eMap.get(lineArr[0]).add(lineArr[1]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ElementDescriptor(eMap, this.descriptionValueHandler);
    }

    private void applyOverrides() {
        this.versionControl = new VersionControl();
        List<String> versionList = this.versionControl.createVersionList();
        for (String ver : versionList) {
            File versionFile = new File(String.format("%soverride_v%s.txt", DraftFormat.getFormatDir(), ver));
            if (!versionFile.isFile()) continue;
            this.applyOverrides(versionFile);
        }
    }

    private void applyOverrides(File versionFile) {
        try (BufferedReader br = new BufferedReader(new FileReader(versionFile));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.trim().isEmpty() || line.matches("^\\s*#.*")) continue;
                String[] lineArr = line.split("\\s+", 2);
                ArrayList<ElementDescriptor> modifiedEntElems = new ArrayList<ElementDescriptor>();
                if (lineArr[0].contains("JOB")) {
                    modifiedEntElems.add(this.formatMap.get((Object)FormatType.JOB));
                }
                if (lineArr[0].contains("SMART")) {
                    modifiedEntElems.add(this.formatMap.get((Object)FormatType.SMART));
                }
                if (lineArr[0].contains("SUB")) {
                    modifiedEntElems.add(this.formatMap.get((Object)FormatType.SUB));
                }
                String lineElement = this.extractOverride("element", lineArr[1]);
                String lineAttribute = this.extractOverride("attribute", lineArr[1]);
                LinkedHashMap<String, String> overrides = this.extractOverrideValues(lineArr[1]);
                for (ElementDescriptor modifiedEntElem : modifiedEntElems) {
                    modifiedEntElem.applyOverride(lineElement, lineAttribute, overrides);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private LinkedHashMap<String, String> extractOverrideValues(String string) {
        Pattern p = Pattern.compile(".*?(\\S+)=(\\S+.*?)(\\S+=.*)?");
        Matcher m = p.matcher(string);
        LinkedHashMap<String, String> toRet = null;
        while (m.matches()) {
            String key = m.group(1);
            String val = m.group(2).trim();
            String tail = m.group(3);
            if (toRet == null) {
                toRet = new LinkedHashMap<String, String>();
            }
            toRet.put(key, val);
            if (tail == null) break;
            m = p.matcher(tail);
        }
        return toRet;
    }

    private String extractOverride(String key, String string) {
        String regex = String.format(".*?%s\\s*:\\s*(\\S+).*", key);
        Pattern keyPat = Pattern.compile(regex);
        Matcher m = keyPat.matcher(string);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    private static String getCurrentVersion() {
        return Params.instance().getGUIVersion();
    }

    public String getDraftHeader() {
        Object header = "";
        if (loadedVersion.equals("7")) {
            String XML_line_1 = "<?xml version='1.0' encoding='" + String.valueOf(this.draftCharset) + "' ?>";
            String XML_line_2 = "<!DOCTYPE DEFTABLE SYSTEM \"deftable.dtd\">";
            header = String.format("%s\n%s\n<DEFTABLE>\n", XML_line_1, XML_line_2);
        } else {
            header = (String)header + "<?xml version=\"1.0\" encoding=\"" + String.valueOf(this.draftCharset) + "\"?>\n";
            header = (String)header + "<DEFTABLE xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"Folder.xsd\">\n";
        }
        return header;
    }

    public static Charset getDraftCharSet() {
        Charset draftCharsetName = StandardCharsets.ISO_8859_1;
        if (SettingsBooleanKeys.ENABLE_UTF8_DRAFT.isEnabled()) {
            draftCharsetName = StandardCharsets.UTF_8;
        }
        return draftCharsetName;
    }

    public String getDraftFooter() {
        return "</DEFTABLE>";
    }

    public String getDumbTableHeaderFormat() {
        if (loadedVersion.equals("7")) {
            return "<TABLE\n\tDATACENTER=\"%s\"\n\tTABLE_NAME=\"%s\"\n\tTABLE_USERDAILY=\"%s\"\n\tUSED_BY_CODE=\"0\" >\n";
        }
        return "<FOLDER\n\tDATACENTER=\"%s\"\n\tFOLDER_NAME=\"%s\"\n\tFOLDER_ORDER_METHOD=\"%s\"\n\tPLATFORM=\"%s\"\n\t%s\n\tUSED_BY_CODE=\"0\" >\n";
    }

    public String getDumbTableFooterFormat() {
        if (loadedVersion.equals("7")) {
            return "</TABLE>\n";
        }
        return "</FOLDER>\n";
    }

    public ElementDescriptor getEntityElement(SchedEntity ent) {
        return this.formatMap.get((Object)(switch (ent.type()) {
            case SchedEntity.TYPE.JOB -> FormatType.JOB;
            case SchedEntity.TYPE.SUB_TABLE -> FormatType.SUB;
            case SchedEntity.TYPE.SMART_TABLE -> FormatType.SMART;
            default -> FormatType.JOB;
        }));
    }

    static {
        loadedVersion = "";
    }

    public static enum FormatType {
        JOB{

            public String toString() {
                return "job";
            }
        }
        ,
        SMART{

            public String toString() {
                return "smart_table";
            }
        }
        ,
        SUB{

            public String toString() {
                return "sub_table";
            }
        };

    }
}

