/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.dataObject;

import com.bmc.ctmconvert.common.dataObject.Attributes;
import com.bmc.ctmconvert.common.dataObject.DataObject;
import com.bmc.ctmconvert.common.dataObject.DataObjectStream;
import com.bmc.ctmconvert.common.dataObject.query.DataObjectQuery;
import com.bmc.ctmconvert.utils.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class OnMemoryStorer
implements DataObject {
    private final Map<Integer, Integer> childToParent = new HashMap<Integer, Integer>();
    private final Map<Integer, List<Integer>> parentChildMap = new HashMap<Integer, List<Integer>>();
    private final Map<Integer, List<Pair<String, String>>> entitiesAttributes = new HashMap<Integer, List<Pair<String, String>>>();
    private final PairToID pairToId = new PairToID();
    private int currentUnitID = 0;
    private final Map<String, String> calendars = new HashMap<String, String>();

    public int store(int parentId, List<Pair<String, String>> attributes) {
        int id = ++this.currentUnitID;
        this.childToParent.put(id, parentId);
        this.parentChildMap.computeIfAbsent(parentId, ArrayList::new).add(id);
        this.entitiesAttributes.put(id, attributes);
        for (Pair<String, String> pair : attributes) {
            this.pairToId.put(pair, id);
        }
        return id;
    }

    public void storeCalendar(String name, String content) {
        this.calendars.put(name, content);
    }

    public String getCalendar(String name) {
        return this.calendars.get(name);
    }

    public Map<String, String> getCalendars() {
        return this.calendars;
    }

    @Override
    public Map<Integer, Integer> getHirarchy() {
        return new HashMap<Integer, Integer>(this.childToParent);
    }

    @Override
    public void foreachEntity(DataObject.AttributeHandler handler) {
        for (Integer id : this.entitiesAttributes.keySet()) {
            List<Pair<String, String>> attributes = this.entitiesAttributes.get(id);
            handler.handle(id, attributes);
        }
    }

    @Override
    public void foreachEntity(Consumer<Integer> consumer) {
        this.entitiesAttributes.keySet().forEach(consumer);
    }

    public Map<Integer, List<Pair<String, String>>> getEntitiesAttributes() {
        return this.entitiesAttributes;
    }

    @Override
    public void WhenAttributeEqual(String attributeKey, String attributeValue, Consumer<Integer> consumer) {
        List<Integer> ids = this.pairToId.getIdsThatHaveKeyWithValue(attributeKey, attributeValue);
        for (Integer integer : ids) {
            consumer.accept(integer);
        }
    }

    @Override
    public List<Pair<String, String>> getAttributes(Integer unitId) {
        ArrayList<Pair<String, String>> ret = new ArrayList<Pair<String, String>>();
        if (this.entitiesAttributes.containsKey(unitId)) {
            ret.addAll((Collection<Pair<String, String>>)this.entitiesAttributes.get(unitId));
        }
        return ret;
    }

    @Override
    public List<String> getAttribute(String attributeKey, Integer unitId) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Pair<String, String> pair : this.getAttributes(unitId)) {
            if (!pair.getKey().equals(attributeKey)) continue;
            ret.add(pair.getValue());
        }
        return ret;
    }

    @Override
    public OnMemoryStream stream() {
        return new OnMemoryStream(this);
    }

    @Override
    public List<Integer> getChildrenIds(Integer unitId) {
        return this.parentChildMap.getOrDefault(unitId, new ArrayList());
    }

    @Override
    public List<Integer> getChildrenIds(int unitId, String WithAttribute) {
        List<Integer> ret = this.getChildrenIds(unitId);
        List<Integer> idsWithAttribute = this.pairToId.getIdWhoHasKey(WithAttribute);
        ret.retainAll(idsWithAttribute);
        return ret;
    }

    @Override
    public List<Integer> getChildrenIds(int unitId, String withAttributeName, String withAttributeValue) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (this.parentChildMap.containsKey(unitId)) {
            ret.addAll((Collection)this.parentChildMap.get(unitId));
        }
        List<Integer> idsWithAttribute = this.pairToId.getIdsThatHaveKeyWithValue(withAttributeName, withAttributeValue);
        ret.retainAll(idsWithAttribute);
        return ret;
    }

    @Override
    public void whenHasAttribute(String attribute, Consumer<Integer> consumer) {
        List<Integer> ids = this.pairToId.getIdWhoHasKey(attribute);
        if (ids != null) {
            ids.forEach(consumer);
        }
    }

    @Override
    public List<Integer> getIdsWhoHasAttribute(String attribute) {
        List<Integer> ids = this.pairToId.getIdWhoHasKey(attribute);
        return new ArrayList<Integer>(ids);
    }

    @Override
    public Optional<Integer> getParent(int childId) {
        Integer parentId = this.childToParent.get(childId);
        return Optional.ofNullable(parentId);
    }

    @Override
    public Optional<Integer> getFirstAncestor(int id, String key, String valueToFind) {
        Optional<Integer> candidateParent = this.getParent(id);
        while (candidateParent.isPresent()) {
            Integer parentId = candidateParent.get();
            List<String> attributeValues = this.getAttribute(key, parentId);
            if (attributeValues.contains(valueToFind)) {
                return candidateParent;
            }
            candidateParent = this.getParent(parentId);
        }
        return candidateParent;
    }

    @Override
    public Optional<Integer> getFirstAncestor(int id, Predicate<Attributes> predicate) {
        Optional<Integer> candidateParent = this.getParent(id);
        while (candidateParent.isPresent()) {
            Integer parentId = candidateParent.get();
            List<Pair<String, String>> attributePairs = this.getAttributes(parentId);
            Attributes attributes = new Attributes(attributePairs);
            if (predicate.test(attributes)) {
                return candidateParent;
            }
            candidateParent = this.getParent(parentId);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getAttributeValueFromParent(int childId, String attributeKey) {
        Optional<Integer> candidateParent = this.getFirstAncestor(childId, attributes -> attributes.hasAttribute(attributeKey));
        return candidateParent.map(this::getAttributes).flatMap(attr -> attr.stream().filter(attribute -> ((String)attribute.getKey()).equals(attributeKey)).findFirst()).map(Pair::getValue);
    }

    @Override
    public Optional<String> findFirstAttribute(String attributeName, Integer unitId) {
        return this.getAttribute(attributeName, unitId).stream().findFirst();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName() + "\n");
        for (Integer id : this.entitiesAttributes.keySet()) {
            List<Pair<String, String>> attributes = this.entitiesAttributes.get(id);
            for (Pair<String, String> pair : attributes) {
                stringBuilder.append(id).append("\t").append(pair.getKey()).append("\t").append(pair.getValue()).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public static class PairToID {
        private final HashMap<String, List<Pair<String, String>>> keyToPair = new LinkedHashMap<String, List<Pair<String, String>>>();
        private final HashMap<Pair<String, String>, ArrayList<Integer>> PairToIds = new HashMap();

        public String toString() {
            return super.toString() + "\nPairToID [keyToPair=" + String.valueOf(this.keyToPair) + "]";
        }

        public void put(Pair<String, String> pair, int id) {
            if (!this.PairToIds.containsKey(pair)) {
                this.PairToIds.put(pair, new ArrayList());
            }
            if (!this.keyToPair.containsKey(pair.getKey())) {
                this.keyToPair.put(pair.getKey(), new ArrayList());
            }
            this.PairToIds.get(pair).add(id);
            if (!this.keyToPair.get(pair.getKey()).contains(pair)) {
                this.keyToPair.get(pair.getKey()).add(pair);
            }
        }

        public List<Integer> getIdsThatHaveKeyWithValue(String Key2, String Value) {
            Pair<String, String> pair = new Pair<String, String>(Key2, Value);
            ArrayList<Integer> ret = new ArrayList<Integer>();
            ArrayList<Integer> ids = this.PairToIds.get(pair);
            if (ids != null) {
                ret.addAll(ids);
            }
            return ret;
        }

        public List<Integer> getIdWhoHasKey(String key) {
            if (!this.keyToPair.containsKey(key)) {
                return Collections.emptyList();
            }
            List<Pair<String, String>> pairsWithId = this.keyToPair.get(key);
            HashSet<Integer> set = new HashSet<Integer>();
            for (Pair<String, String> pair : pairsWithId) {
                ArrayList<Integer> ids = this.PairToIds.get(pair);
                set.addAll(ids);
            }
            return new ArrayList<Integer>(set);
        }
    }

    public static class OnMemoryStream
    implements DataObjectStream {
        private List<Integer> entitesList = null;
        private final OnMemoryStorer db;

        public OnMemoryStream(OnMemoryStorer onMemoryStorer) {
            this.db = onMemoryStorer;
        }

        @Override
        public OnMemoryStream filterEntites(DataObjectQuery condition) {
            List<Integer> ret = condition.filter(this.db);
            this.filter(ret);
            return this;
        }

        private void filter(List<Integer> fileredList) {
            this.entitesList = this.entitesList == null ? fileredList : this.entitesList.stream().filter(fileredList::contains).collect(Collectors.toList());
        }

        @Override
        public void forEachChildesIds(ParentHandler handler) {
            for (Integer unitId : this.entitesList) {
                List childIds = this.db.parentChildMap.getOrDefault(unitId, Collections.emptyList());
                for (Integer childId : childIds) {
                    handler.handle(childId, unitId);
                }
            }
        }

        @Override
        public void forEachEntityId(Consumer<Integer> consumer) {
            if (this.entitesList != null) {
                for (Integer unitId : this.entitesList) {
                    consumer.accept(unitId);
                }
            }
        }

        @Override
        public void forEachAttributes(DataObject.AttributeHandler handler) {
            for (Integer unitId : this.entitesList) {
                List<Pair<String, String>> attributes = this.db.entitiesAttributes.get(unitId);
                handler.handle(unitId, attributes);
            }
        }

        @Override
        public void forEachEntityIdWithSpecificAttribute(String attribute, DataObject.SpecificAttributeHandler consumer) {
            List<Integer> ids = this.db.pairToId.getIdWhoHasKey(attribute);
            this.filter(ids);
            for (Integer unitId : this.entitesList) {
                List<Pair<String, String>> attributes = this.db.getAttributes(unitId);
                attributes.stream().filter((? super T pair) -> ((String)pair.getKey()).equals(attribute)).map(Pair::getValue).forEach(value -> consumer.handle(unitId, (String)value));
            }
        }
    }

    @FunctionalInterface
    public static interface ParentHandler {
        public void handle(int var1, int var2);
    }
}

