/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.calendars;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.common.draftwriter.DraftFormat;
import com.bmc.ctmconvert.io.FileUtils;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;

public class XmlDefCalFile
implements DefCalFile {
    private final PrintStream outStream;
    public static final String NEW_LINE = String.format("%n", new Object[0]);

    XmlDefCalFile(OutputStream outputStream) {
        this.outStream = this.createStream(outputStream);
        this.writeHeader();
    }

    private PrintStream createStream(OutputStream outputStream) {
        try {
            return new PrintStream(outputStream, false, FileUtils.getDraftCharset().toString());
        }
        catch (UnsupportedEncodingException e) {
            ExceptionHandler.writeToExceptionFile(e);
            return new PrintStream(outputStream);
        }
    }

    private void writeHeader() {
        DraftFormat.instance();
        String encoding = DraftFormat.getDraftCharSet().toString();
        this.outStream.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n");
        this.outStream.println("<!DOCTYPE DEFCAL SYSTEM \"defcal.dtd\">");
        this.outStream.println("<DEFCAL>");
    }

    @Override
    public void close() {
        this.writeFooter();
        this.outStream.close();
    }

    private void writeFooter() {
        this.outStream.println("</DEFCAL>");
    }

    @Override
    public void write(CtmCalendar cal, boolean negative) {
        Optional<CtmCalendar.CalendarData> calendarData = cal.getCalendarData(negative);
        Optional<String> calendarContent = calendarData.map(data -> {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("\t<CALENDAR DATACENTER=\"%s\" NAME=\"%s\" TYPE=\"Relative\">", data.dataCenter, GlobalFunctions.EncodeXMLString(data.name))).append(NEW_LINE);
            for (CtmCalendar.CalendarData.YearData curYear : data.years) {
                String daysString = this.getDaysString(curYear, negative);
                sb.append(String.format("\t\t<YEAR NAME=\"%d\" DAYS=\"%s\" DESCRIPTION=\"%s\"/>", curYear.year, daysString, GlobalFunctions.EncodeXMLString(curYear.description))).append(NEW_LINE);
            }
            sb.append("\t</CALENDAR>");
            return sb.toString();
        });
        calendarContent.ifPresent(this.outStream::println);
    }

    private String getDaysString(CtmCalendar.CalendarData.YearData yearData, boolean negative) {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        int year = yearData.year;
        GregorianCalendar cal = new GregorianCalendar(year, 0, 1);
        while (cal.get(1) == year) {
            int day = cal.get(5);
            int month = cal.get(2) + 1;
            result.add(yearData.days.contains(month, day));
            ((Calendar)cal).add(6, 1);
        }
        return result.stream().map(b -> this.negateIfNeeded(negative, (Boolean)b)).map(b -> Boolean.TRUE.equals(b) ? "Y" : "N").collect(Collectors.joining());
    }

    private boolean negateIfNeeded(boolean negative, Boolean value) {
        if (negative) {
            return value == false;
        }
        return value;
    }

    @Override
    public void writePeriodic(List<Properties> perCal, String dcName, String calName) {
        this.outStream.printf("\t<CALENDAR DATACENTER=\"%s\" NAME=\"%s\" TYPE=\"Periodic\">%n", dcName, GlobalFunctions.EncodeXMLString(calName));
        for (Properties year : perCal) {
            this.outStream.printf("\t\t<YEAR DAYS=\"%s\" NAME=\"%s\"/>%n", year.getProperty("DAYS"), year.getProperty("NAME"));
        }
        this.outStream.println("\t</CALENDAR>");
    }

    @Override
    public void writeRBC(Properties rbc) {
        this.outStream.println("\t<RULE_BASED_CALENDAR");
        for (Map.Entry<Object, Object> entry : rbc.entrySet()) {
            String key = entry.getKey().toString();
            if (key.equalsIgnoreCase("RETRO") || key.equalsIgnoreCase("LEVEL")) continue;
            this.outStream.printf("\t\t%s=\"%s\"%n", entry.getKey(), GlobalFunctions.EncodeXMLString((String)entry.getValue()));
        }
        this.outStream.println("\t/>");
    }
}

