/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.calendars;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.common.calendars.JsonDefCalFile;
import com.bmc.ctmconvert.common.calendars.XmlAndJsonDefCalFile;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;

public interface DefCalFile
extends AutoCloseable {
    public static DefCalFile createDefCalFile() throws IOException {
        OutputStream jsonRuleBasedCalendars = DefCalFile.createCalendarFile(GlobalFunctions.RBC_JSON_FILE);
        OutputStream jsonRegularCalendars = DefCalFile.createCalendarFile(GlobalFunctions.REGULAR_CALENDAR_JSON_FILE);
        if (SettingsBooleanKeys.isSaas() || !SettingsBooleanKeys.isXmlCalendarFileEnabled()) {
            return new JsonDefCalFile(jsonRuleBasedCalendars, jsonRegularCalendars);
        }
        return new XmlAndJsonDefCalFile(DefCalFile.createCalendarFile(GlobalFunctions.CALENDAR_XML_FILE), jsonRuleBasedCalendars, jsonRegularCalendars);
    }

    private static OutputStream createCalendarFile(String name) throws IOException {
        Path path = Paths.get(Globs.TEMP_EVALUATION_DIR, new String[0]).resolve(name);
        return new FileOutputStream(path.toFile().getAbsolutePath());
    }

    @Override
    public void close();

    public void write(CtmCalendar var1, boolean var2);

    public void writePeriodic(List<Properties> var1, String var2, String var3);

    public void writeRBC(Properties var1);
}

