/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.ExceptionHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class StreamGobbler
extends Thread {
    private BufferedReader bufferReader;
    private StringBuffer outputStream;
    private File outputFile;

    public StreamGobbler(InputStream inputStream) {
        this.bufferReader = new BufferedReader(new InputStreamReader(inputStream));
        this.outputStream = new StringBuffer();
    }

    public StreamGobbler(InputStream inputStream, StringBuffer outputStream) {
        this.bufferReader = new BufferedReader(new InputStreamReader(inputStream));
        this.outputStream = outputStream == null ? new StringBuffer() : outputStream;
    }

    @Override
    public void run() {
        try {
            BufferedWriter bufferedWriter = null;
            if (this.outputFile != null) {
                bufferedWriter = new BufferedWriter(new FileWriter(this.outputFile));
            }
            String line = null;
            while ((line = this.bufferReader.readLine()) != null) {
                this.outputStream.append(line + "\n");
                if (bufferedWriter == null) continue;
                bufferedWriter.write(line + "\n");
            }
            this.bufferReader.close();
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
    }

    public String getStream() {
        return this.outputStream.toString();
    }

    public void setOutputFile(File output) {
        this.outputFile = output;
    }
}

