/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.exceptions.ConvertorException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class SelfConversionCLIInternalExceptionHandler
implements ExceptionHandler.IExceptionHandler {
    private static File selfConversionCLIexceptionFile = null;

    public SelfConversionCLIInternalExceptionHandler() {
        selfConversionCLIexceptionFile = new File(Globs.LOGS_DIR + Globs.SELF_CONVERSION_CLI_EXCEPTION_FILE + ".txt");
    }

    @Override
    public void writeToExceptionFile(String message) {
        String timeString = GlobalFunctions.getCurrentDateByFormat("yyyy-MM-dd HH:mm:ss");
        try (BufferedWriter fileBW = new BufferedWriter(new FileWriter(selfConversionCLIexceptionFile, true));){
            fileBW.write(timeString + "\n" + message);
            fileBW.write("\n");
            fileBW.write("*************************************************");
            fileBW.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeToExceptionFile(Exception e) {
        this.writeToExceptionFile(this.getStackTrace(e));
        if (e instanceof ConvertorException) {
            String entityHandled = " EntitCurrenty id";
            if (((ConvertorException)e).isCurrentEntityCompleted()) {
                entityHandled = "Last handled Entity id";
            }
            try (BufferedWriter fileBW = new BufferedWriter(new FileWriter(selfConversionCLIexceptionFile, true));){
                fileBW.write("\n");
                fileBW.write("*************************************************");
                String failureMessage = "\n" + entityHandled + "\t:" + ((ConvertorException)e).getCurrentEntity() + "\nState\t\t\t:" + ((ConvertorException)e).getCurrentEntityState() + "\n";
                fileBW.write(failureMessage);
                fileBW.write("Error cause\t\t:" + ((ConvertorException)e).getError() + "\n");
                fileBW.write("*************************************************\n");
                fileBW.write("\n");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        e.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }
}

