/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.ExtensionFileFilter;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.OrElse;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.services.VendorDataManager;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.translate.UnicodeUnescaper;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GlobalFunctions {
    public static final BiPredicate<SchedEntity, String> JobHasAutoedit = (entity, autoEditKey) -> entity.getAutoedits().containsKey(autoEditKey);
    public static final Predicate<SchedEntity> jobHasTaskType = entity -> entity.getAttr("TASKTYPE") != null;
    public static final int DAYS_IN_WEEK = 7;
    private static HashMap<String, Integer> fieldCounters = new HashMap();
    private static String lastFilePath = ".";
    private static final String[] MONTH_SHOT = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private static final String[] MONTH_FULL = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public static String RBC_JSON_FILE = "rule_based_calendars.json";
    public static String REGULAR_CALENDAR_JSON_FILE = "regular_calendars.json";
    public static String CALENDAR_XML_FILE = "calendars.xml";

    public static String nullDevice() {
        if (GlobalFunctions.isWindows()) {
            return "NUL";
        }
        return "/dev/null";
    }

    public static int getComponentIndex(Component component) {
        if (component != null && component.getParent() != null) {
            Container c = component.getParent();
            for (int i = 0; i < c.getComponentCount(); ++i) {
                if (c.getComponent(i) != component) continue;
                return i;
            }
        }
        return -1;
    }

    public static String createDatasourceDirectory(Properties projectData) {
        return GlobalFunctions.createDatasourceDirectory(projectData, false);
    }

    public static String createDatasourceDirectory(Properties projectData, boolean isOverride) {
        String dataDirectoryPath = null;
        String projectName = projectData.getProperty("NAME");
        String projectDirectory = ConversionEntitiesService.getProjectDirectory(projectName);
        ConversionLogger.getLogger().severe(() -> "project Data property:" + projectData.getProperty("NAME") + "   project directory:" + projectDirectory);
        File datasourceDirectory = new File(projectDirectory);
        if (isOverride && datasourceDirectory.exists()) {
            GlobalFunctions.deleteDir(datasourceDirectory);
        }
        if (!datasourceDirectory.isDirectory() && !datasourceDirectory.mkdir()) {
            ProcessAlertsManager.instance().addMessage(TextManager.instance().get("CREATE_DIRECTORY_FAILED_MESSAGE"));
            ConversionLogger.getLogger().severe("project directory wasn't created");
        } else {
            File exportDirectory = new File(datasourceDirectory.getAbsolutePath() + Globs.DIRSEP + "data");
            if (!exportDirectory.mkdir()) {
                ProcessAlertsManager.instance().addMessage(TextManager.instance().get("CREATE_DIRECTORY_FAILED_MESSAGE"));
                ConversionLogger.getLogger().severe("project data directory wasn't created");
            } else {
                dataDirectoryPath = exportDirectory.getAbsolutePath() + Globs.DIRSEP;
            }
        }
        return dataDirectoryPath;
    }

    public static Map<String, String> dataSourceProps2Map(String dataSourcePath) throws IOException {
        File propertiesFile = new File(dataSourcePath + Globs.DIRSEP + "properties.cfg");
        LinkedHashMap<String, String> toRet = null;
        if (propertiesFile.isFile()) {
            try (BufferedReader fReader = new BufferedReader(new FileReader(propertiesFile));){
                String line;
                while ((line = fReader.readLine()) != null) {
                    if (!line.contains("=")) continue;
                    String[] tmpArr = line.trim().split("=", 2);
                    if (toRet == null) {
                        toRet = new LinkedHashMap<String, String>();
                    }
                    toRet.put(tmpArr[0], tmpArr[1]);
                }
            }
        }
        return toRet;
    }

    public static void map2DataSourcePropertiesFile(Map<String, String> map, String dataSourcePath, boolean merge) throws IOException {
        File propertiesFile;
        Map<String, String> oldProps = null;
        if (merge) {
            oldProps = GlobalFunctions.dataSourceProps2Map(dataSourcePath);
        }
        if (!(propertiesFile = new File(dataSourcePath + Globs.DIRSEP + "properties.cfg")).isFile()) {
            File parentDirFile = new File(propertiesFile.getParent());
            if (!parentDirFile.isDirectory()) {
                parentDirFile.mkdirs();
            }
            propertiesFile.createNewFile();
        }
        try (BufferedWriter fWriter = new BufferedWriter(new FileWriter(propertiesFile));){
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (oldProps != null) {
                    oldProps.remove(entry.getKey());
                }
                fWriter.write(String.format("%s=%s%n", entry.getKey(), entry.getValue()));
            }
            if (oldProps != null) {
                for (Map.Entry<String, String> entry : oldProps.entrySet()) {
                    fWriter.write(String.format("%s=%s%n", entry.getKey(), entry.getValue()));
                }
            }
        }
    }

    public static File[] browseClick(JTextField textField, String[] extentions) {
        return GlobalFunctions.browseClick(textField, extentions, false);
    }

    public static File[] browseClick(JTextField textField, String[] extentions, boolean multipleSelection) {
        FileFilter filter;
        File[] files = null;
        boolean browseDir = false;
        for (String ext : extentions) {
            if (!ext.equals(TextManager.instance().get("FILE_CHOOSER_TITLE_DIRECTORY"))) continue;
            browseDir = true;
        }
        String currPath = textField.getText();
        String folder = ".";
        folder = currPath != null && !currPath.isEmpty() ? new File(currPath).getAbsolutePath() : lastFilePath;
        String dialogTitle = String.format("%s %s %s%s", TextManager.instance().get("FILE_CHOOSER_TITLE_CHOOSE"), textField.getName().replaceAll("\\s*[Ff]ile$\\s*", ""), browseDir ? TextManager.instance().get("FILE_CHOOSER_TITLE_DIRECTORY") : TextManager.instance().get("FILE_CHOOSER_TITLE_FILE"), "...");
        JFileChooser fileChooser = new JFileChooser(folder){
            private static final long serialVersionUID = 1L;

            @Override
            protected JDialog createDialog(Component parent) throws HeadlessException {
                JDialog dialog = super.createDialog(parent);
                dialog.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(FlowGlobals.BMC_ICON_PATH)));
                return dialog;
            }
        };
        fileChooser.setDialogTitle(dialogTitle);
        fileChooser.setMultiSelectionEnabled(multipleSelection);
        Object fileDescription = "";
        if (browseDir) {
            fileDescription = TextManager.instance().get("FILE_CHOOSER_TITLE_DIRECTORY");
        } else {
            for (int i = 0; i < extentions.length; ++i) {
                if (i > 0) {
                    fileDescription = (String)fileDescription + ", ";
                }
                fileDescription = (String)fileDescription + "." + extentions[i].toUpperCase();
            }
            fileDescription = (String)fileDescription + " " + TextManager.instance().get("FILE_CHOOSER_EXTENTION_FILTER_FILES");
        }
        if (browseDir) {
            filter = new FileFilter(){

                @Override
                public String getDescription() {
                    return TextManager.instance().get("FILE_CHOOSER_TITLE_DIRECTORY");
                }

                @Override
                public boolean accept(File f) {
                    return f.isDirectory();
                }
            };
            fileChooser.setFileSelectionMode(2);
        } else {
            filter = new ExtensionFileFilter((String)fileDescription, extentions);
        }
        if (extentions != null && extentions.length > 0) {
            fileChooser.setFileFilter(filter);
        }
        if (fileChooser.showOpenDialog(textField) == 0) {
            File[] fileArray;
            if (multipleSelection) {
                fileArray = fileChooser.getSelectedFiles();
            } else {
                File[] fileArray2 = new File[1];
                fileArray = fileArray2;
                fileArray2[0] = fileChooser.getSelectedFile();
            }
            files = fileArray;
            if (files != null) {
                if (files[0].isFile()) {
                    lastFilePath = files[0].getParent();
                } else if (files[0].isDirectory()) {
                    lastFilePath = files[0].getAbsolutePath();
                }
                if (browseDir) {
                    textField.setText(lastFilePath);
                } else {
                    StringBuilder filesStr = new StringBuilder();
                    filesStr.append(files[0].toString());
                    for (int index = 1; index < files.length; ++index) {
                        filesStr.append(";").append(files[index].toString());
                    }
                    textField.setText(filesStr.toString());
                }
                textField.requestFocusInWindow();
            }
        }
        return files;
    }

    public static boolean isWindows() {
        String whichOS = System.getProperty("os.name");
        return whichOS.contains("Windows") || whichOS.contains("windows");
    }

    public static String convertFullVendorName2VendorName(String fullVendorName) {
        if (fullVendorName.toLowerCase().contains("tidal")) {
            return "TIDAL";
        }
        if (fullVendorName.toLowerCase().contains("autosys")) {
            return "CA_AUTOSYS";
        }
        if (fullVendorName.toLowerCase().contains("wlm")) {
            return "CA_WLM";
        }
        if (fullVendorName.toLowerCase().contains("jobtrac")) {
            return "JOBTRAC";
        }
        if (fullVendorName.toLowerCase().contains("tivoli")) {
            return "TWS";
        }
        if (fullVendorName.toLowerCase().contains("dollar")) {
            return "DOLLAR_UNIVERSE";
        }
        if (fullVendorName.equalsIgnoreCase("uc4")) {
            return "UC4";
        }
        if (fullVendorName.toLowerCase().contains("cron")) {
            return "CRON";
        }
        if (fullVendorName.toLowerCase().contains("ms")) {
            return "MS";
        }
        if (fullVendorName.toLowerCase().contains("appworx")) {
            return "AppWorx";
        }
        if (fullVendorName.toLowerCase().contains("oozie")) {
            return "Oozie";
        }
        if (fullVendorName.toLowerCase().contains("sap")) {
            return "SAP";
        }
        if (fullVendorName.toLowerCase().contains("dseries")) {
            return "dSeries";
        }
        if (fullVendorName.toLowerCase().contains("redwood_bpa")) {
            return "Redwood_BPA";
        }
        if (fullVendorName.toLowerCase().contains("redwood")) {
            return "Redwood";
        }
        if (fullVendorName.toLowerCase().contains("zena")) {
            return "Zena";
        }
        if (fullVendorName.toLowerCase().contains("jp1")) {
            return "JP1";
        }
        if (fullVendorName.toLowerCase().contains("connect")) {
            return "CONNECT_DIRECT";
        }
        return null;
    }

    public static void copy(File src, File dst) throws IOException {
        if (src.isDirectory()) {
            if (!dst.exists() ? !dst.mkdirs() : !dst.isDirectory()) {
                throw new IOException("Failed to copy " + String.valueOf(src) + " to " + String.valueOf(dst));
            }
            File[] files = src.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().matches("^[.]+$")) {
                    // empty if block
                }
                GlobalFunctions.copy(files[i], new File(dst.getAbsolutePath() + Globs.DIRSEP + files[i].getName()));
            }
            return;
        }
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dst);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
    }

    public static void copyFolder(Path src, Path dest) throws IOException {
        try (Stream<Path> files = Files.walk(src, new FileVisitOption[0]);){
            files.forEach(source -> GlobalFunctions.copyPath(source, dest.resolve(src.relativize((Path)source))));
        }
    }

    private static void copyPath(Path source, Path dest) {
        try {
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String getCurrentDateByFormat(String timeFormat) {
        Calendar currentDate = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat(timeFormat);
        return formatter.format(currentDate.getTime());
    }

    public static boolean isValidDate(String inDate, String inDateFormat) {
        if (inDate == null) {
            return false;
        }
        if (inDateFormat == null) {
            return false;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(inDateFormat);
        if (inDate.trim().length() != dateFormat.toPattern().length()) {
            return false;
        }
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(inDate.trim());
        }
        catch (ParseException pe) {
            return false;
        }
        return true;
    }

    public static Date getDateByFormat(String dateString, String timeFormat) {
        Date retDate = null;
        if (dateString == null) {
            return retDate;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(timeFormat);
        try {
            retDate = formatter.parse(dateString);
        }
        catch (ParseException ex) {
            ExceptionHandler.writeToExceptionFile(ex);
        }
        return retDate;
    }

    public static Date getDateByYearMonthDay(Integer year, Integer month, Integer day) {
        Date retDate = null;
        String dateStr = day + "-" + month + "-" + year;
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
        try {
            retDate = formatter.parse(dateStr);
        }
        catch (ParseException ex) {
            ExceptionHandler.writeToExceptionFile(ex);
        }
        return retDate;
    }

    public static String getDateStringFromDate(Date date, String timeFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(timeFormat);
        return formatter.format(date);
    }

    public static Integer[] getYearMonthDayFromDate(Date date) {
        Integer[] yymmdd = new Integer[]{-1, -1, -1};
        String dateString = GlobalFunctions.getDateStringFromDate(date, "yyyyMMdd");
        yymmdd[0] = Integer.parseInt(dateString.substring(0, 4));
        yymmdd[1] = Integer.parseInt(dateString.substring(4, 6));
        yymmdd[2] = Integer.parseInt(dateString.substring(6, 8));
        return yymmdd;
    }

    public static int convertWeekdayToCalendarDayOfWeek(String weekDay) {
        int dayOfWeek = -1;
        if (weekDay.equalsIgnoreCase("Sunday") || weekDay.equalsIgnoreCase("Sun")) {
            dayOfWeek = 1;
        } else if (weekDay.equalsIgnoreCase("Monday") || weekDay.equalsIgnoreCase("Mon")) {
            dayOfWeek = 2;
        } else if (weekDay.equalsIgnoreCase("Tuesday") || weekDay.equalsIgnoreCase("Tue")) {
            dayOfWeek = 3;
        } else if (weekDay.equalsIgnoreCase("Wednesday") || weekDay.equalsIgnoreCase("Wed")) {
            dayOfWeek = 4;
        } else if (weekDay.equalsIgnoreCase("Thursday") || weekDay.equalsIgnoreCase("Thu")) {
            dayOfWeek = 5;
        } else if (weekDay.equalsIgnoreCase("Friday") || weekDay.equalsIgnoreCase("Fri")) {
            dayOfWeek = 6;
        } else if (weekDay.equalsIgnoreCase("Saturday") || weekDay.equalsIgnoreCase("Sat")) {
            dayOfWeek = 7;
        }
        return dayOfWeek;
    }

    public static String convertCalendarDayOfWeekToWeekday(int dayOfWeek, boolean shortname) {
        return switch (GlobalFunctions.shiftByFirstDayOfTheWeek(dayOfWeek)) {
            case 1 -> {
                if (shortname) {
                    yield "Sun";
                }
                yield "Sunday";
            }
            case 2 -> {
                if (shortname) {
                    yield "Mon";
                }
                yield "Monday";
            }
            case 3 -> {
                if (shortname) {
                    yield "Tue";
                }
                yield "Tuesday";
            }
            case 4 -> {
                if (shortname) {
                    yield "Wed";
                }
                yield "Wednesday";
            }
            case 5 -> {
                if (shortname) {
                    yield "Thu";
                }
                yield "Thursday";
            }
            case 6 -> {
                if (shortname) {
                    yield "Fri";
                }
                yield "Friday";
            }
            case 7 -> {
                if (shortname) {
                    yield "Sat";
                }
                yield "Saturday";
            }
            default -> "";
        };
    }

    private static int shiftByFirstDayOfTheWeek(int dayOfWeek) {
        RBC.WEEKDAYS firstDayOfTheWeek = VendorDataManager.instance().getVendorData().getFirstDayOfTheWeek();
        int zeroBasedDayOfWeek = dayOfWeek - 1;
        int firstDayOfWeekOffset = RBC.WEEKDAYS.MONDAY.ordinal() - firstDayOfTheWeek.ordinal();
        int zeroBasedDayOfWeekWithOffset = (7 + zeroBasedDayOfWeek - firstDayOfWeekOffset) % 7;
        int oneBasedDayOfWeekWithOffset = zeroBasedDayOfWeekWithOffset + 1;
        return oneBasedDayOfWeekWithOffset;
    }

    public static Integer getNumberOfMonths(Date startDate, Date endDate) {
        Integer numberOfMonths = 0;
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        while (startCal.get(1) < endCal.get(1) || startCal.get(1) == endCal.get(1) && startCal.get(2) <= endCal.get(2)) {
            Integer n = numberOfMonths;
            numberOfMonths = numberOfMonths + 1;
            startCal.add(2, 1);
        }
        return numberOfMonths;
    }

    public static Boolean isToday(Integer year, Integer month, Integer day) {
        boolean today = false;
        Calendar cal = Calendar.getInstance();
        if (year.intValue() == cal.get(1) && month - 1 == cal.get(2) && day.intValue() == cal.get(5)) {
            today = true;
        }
        return today;
    }

    public static boolean isNumber(String in) {
        try {
            Integer.parseInt(in);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public static Optional<Integer> getNumberFrom(String in) {
        try {
            return Optional.of(Integer.parseInt(in));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }

    public static boolean isConversionExist(String confName) {
        return ConversionEntitiesService.getConversionDetails(ConversionEntitiesService.getCurrentProjectName(), confName) != null;
    }

    public static String getUniqueFileOrFoldertName(String defautName, String path) {
        int count = 1;
        Object name = defautName;
        Object fullPath = path + Globs.DIRSEP + defautName;
        File fileOrFolder = new File((String)fullPath);
        StringBuilder buildPath = new StringBuilder();
        while (fileOrFolder.exists()) {
            if (fileOrFolder.isDirectory()) {
                name = defautName + "_" + count;
                fullPath = path + Globs.DIRSEP + (String)name;
            } else if (defautName.contains(".")) {
                int index = defautName.lastIndexOf(".");
                String first = defautName.substring(0, index);
                String second = defautName.substring(index, defautName.length());
                name = first + "_" + count + second;
                buildPath.append(path).append(Globs.DIRSEP).append((String)name);
                fullPath = buildPath.toString();
                buildPath.setLength(0);
            } else {
                name = defautName + "_" + count;
                fullPath = path + Globs.DIRSEP + (String)name;
            }
            fileOrFolder = new File((String)fullPath);
            ++count;
        }
        return name;
    }

    public static boolean isFileExist(String file) {
        File tmpFile = new File(file);
        return tmpFile.exists();
    }

    public static boolean isDirExist(String file) {
        File tmpFile = new File(file);
        return tmpFile.exists() && tmpFile.isDirectory();
    }

    public static String AddQuotes(String str) {
        return "\"" + str + "\"";
    }

    public static ArrayList<String> cmdline2ArgArr(String command) {
        return GlobalFunctions.cmdline2ArgArr(command, false);
    }

    public static ArrayList<String> cmdline2ArgArr(String command, boolean keepQuotes) {
        command = command.replaceAll("[ \t]+", " ");
        ArrayList<String> argsArr = new ArrayList<String>();
        char[] charArr = command.toCharArray();
        String quotes = "";
        char escapeChar = '\u0000';
        int dirSep = 0;
        if (command.matches("^[\"']?(/|\\$).*$")) {
            quotes = "\"'";
            escapeChar = '\\';
            dirSep = 47;
        }
        if (command.matches("^\"?([a-zA-Z]:|%[^%]).*$")) {
            quotes = "\"";
            escapeChar = '^';
            dirSep = 92;
        }
        if (quotes.length() == 0) {
            return null;
        }
        char currQuote = '\u0000';
        boolean escaped = false;
        Object currArg = "";
        for (int charIndex = 0; charIndex < charArr.length; ++charIndex) {
            if (quotes.indexOf(charArr[charIndex]) >= 0 && !escaped) {
                if (currQuote == charArr[charIndex]) {
                    currQuote = '\u0000';
                    if (!keepQuotes) continue;
                    currArg = (String)currArg + charArr[charIndex];
                    continue;
                }
                if (currQuote == '\u0000') {
                    currQuote = charArr[charIndex];
                    if (!keepQuotes) continue;
                    currArg = (String)currArg + charArr[charIndex];
                    continue;
                }
            }
            if (!(charArr[charIndex] != ' ' && charArr[charIndex] != '\t' || escaped || currQuote != '\u0000')) {
                if (argsArr.size() == 0) {
                    int sepIndex = ((String)currArg).lastIndexOf(dirSep);
                    if (sepIndex <= 0) {
                        return null;
                    }
                    String memlib = ((String)currArg).substring(0, sepIndex);
                    String fileName = ((String)currArg).substring(sepIndex + 1);
                    if (memlib.isEmpty() || fileName.isEmpty()) {
                        return null;
                    }
                    if (keepQuotes && memlib.startsWith("\"") && fileName.endsWith("\"")) {
                        memlib = memlib.substring(1);
                        fileName = fileName.substring(0, fileName.length() - 1);
                    }
                    argsArr.add(memlib);
                    argsArr.add(fileName);
                } else {
                    argsArr.add((String)currArg);
                }
                currArg = "";
                continue;
            }
            escaped = charArr[charIndex] == escapeChar;
            currArg = (String)currArg + charArr[charIndex];
        }
        if (argsArr.size() == 0) {
            int sepIndex = ((String)currArg).lastIndexOf(dirSep);
            if (sepIndex <= 0) {
                return null;
            }
            String memLib = ((String)currArg).substring(0, sepIndex);
            String memName = ((String)currArg).substring(sepIndex + 1);
            if (keepQuotes && memLib.startsWith("\"") && memName.endsWith("\"")) {
                memLib = memLib.substring(1);
                memName = memName.substring(0, memName.length() - 1);
            }
            argsArr.add(memLib);
            argsArr.add(memName);
        } else {
            argsArr.add((String)currArg);
            currArg = "";
        }
        if (currQuote != '\u0000') {
            return null;
        }
        return argsArr;
    }

    public static ArrayList<String> string2ArgArr(String command, boolean isWinOS) {
        return GlobalFunctions.string2ArgArr(command, isWinOS, false);
    }

    public static ArrayList<String> string2ArgArr(String command, boolean isWinOS, boolean preserveUnescapedQuotes) {
        ArrayList<String> argsArr = new ArrayList<String>();
        char[] charArr = command.toCharArray();
        String quotes = "";
        char escapeChar = '\u0000';
        if (isWinOS) {
            quotes = "\"";
            escapeChar = '^';
        } else {
            quotes = "\"'";
            escapeChar = '\\';
        }
        char currQuote = '\u0000';
        boolean escaped = false;
        Object currArg = "";
        for (int charIndex = 0; charIndex < charArr.length; ++charIndex) {
            if (quotes.indexOf(charArr[charIndex]) >= 0 && !escaped) {
                if (currQuote == charArr[charIndex]) {
                    if (preserveUnescapedQuotes) {
                        currArg = (String)currArg + charArr[charIndex];
                    }
                    currQuote = '\u0000';
                    continue;
                }
                if (currQuote == '\u0000') {
                    if (preserveUnescapedQuotes) {
                        currArg = (String)currArg + charArr[charIndex];
                    }
                    currQuote = charArr[charIndex];
                    continue;
                }
            }
            if (!(charArr[charIndex] != ' ' && charArr[charIndex] != '\t' || escaped || currQuote != '\u0000')) {
                argsArr.add((String)currArg);
                currArg = "";
                continue;
            }
            escaped = charArr[charIndex] == escapeChar;
            currArg = (String)currArg + charArr[charIndex];
        }
        argsArr.add((String)currArg);
        currArg = "";
        if (currQuote != '\u0000') {
            return null;
        }
        return argsArr;
    }

    public static void deleteDirectory(Path toDelete) throws IOException {
        if (Files.isDirectory(toDelete, new LinkOption[0])) {
            try (Stream<Path> filelist = Files.list(toDelete);){
                for (Path file : filelist.collect(Collectors.toList())) {
                    GlobalFunctions.deleteDirectory(file);
                }
            }
        }
        Files.deleteIfExists(toDelete);
    }

    public static boolean deleteDir(File dir) {
        return GlobalFunctions.deleteDir(dir, true);
    }

    public static boolean deleteDir(File dir, boolean deleteRoot) {
        boolean success = true;
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                success = GlobalFunctions.deleteDir(new File(dir, children[i])) && success;
            }
        }
        if (deleteRoot) {
            success = dir.delete() && success;
        }
        return success;
    }

    public static String getOneStringWithSeparator(String[] strArr, char sep) {
        Object ret = "";
        for (int i = 0; i < strArr.length; ++i) {
            ret = i + 1 == strArr.length ? (String)ret + strArr[i] : (String)ret + strArr[i] + sep;
        }
        return ret;
    }

    public static int getHowManyWords(File f, String word) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(f));){
            String line = null;
            int cnt = 0;
            while ((line = in.readLine()) != null) {
                if (!line.trim().startsWith(word)) continue;
                ++cnt;
            }
            int n = cnt;
            return n;
        }
    }

    public static Integer getDayOfTheWeekIndex(String[] WeekDaysArray, String DayOfTheWeek) {
        Integer i = 0;
        while (i < WeekDaysArray.length && !WeekDaysArray[i].equalsIgnoreCase(DayOfTheWeek)) {
            Integer n = i;
            i = i + 1;
        }
        if (i >= WeekDaysArray.length) {
            i = -1;
        }
        return i;
    }

    public static Integer getDayOfTheWeekCtmIndex(String[] WeekDaysArray, String DayOfTheWeek) {
        Integer i = GlobalFunctions.getDayOfTheWeekIndex(WeekDaysArray, DayOfTheWeek);
        if (i >= 0 && (i = Integer.valueOf(i + 1)) == 7) {
            i = 0;
        }
        return i;
    }

    public static String[] getWeekDaysArray(String firstDayOfTheWeek) {
        String[] WeekDays = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};
        String[] WeekDaysArray = (String[])WeekDays.clone();
        Integer i = GlobalFunctions.getDayOfTheWeekIndex(WeekDays, firstDayOfTheWeek);
        if (i >= 0) {
            Integer j = 0;
            while (j < WeekDays.length) {
                Integer n = i;
                i = i + 1;
                WeekDaysArray[j.intValue()] = WeekDays[n];
                if (i >= WeekDays.length) {
                    i = 0;
                }
                n = j;
                j = j + 1;
            }
        } else {
            System.out.println("Value '" + firstDayOfTheWeek + "' for First day of the week is invalid. Assuming SUN");
        }
        return WeekDaysArray;
    }

    public static Integer getMonthIndex(String[] MonthsArray, String Month2) {
        Integer i = 0;
        while (i < MonthsArray.length && !MonthsArray[i].toString().equalsIgnoreCase(Month2.toString())) {
            Integer n = i;
            i = i + 1;
        }
        i = i >= MonthsArray.length ? Integer.valueOf(-1) : Integer.valueOf(i + 1);
        return i;
    }

    public static String getMonthName(String[] MonthsArray, Integer MonthNumber) {
        if (MonthNumber > MonthsArray.length || MonthNumber < 1) {
            return "ERR";
        }
        return MonthsArray[MonthNumber - 1];
    }

    public static String[] getMonthsArray() {
        return MONTH_SHOT;
    }

    public static void setAllMonth(Properties properties, String value) {
        for (String month : MONTH_SHOT) {
            properties.setProperty(month, value);
        }
    }

    public static String[] getMonthsArray(Boolean fullName) {
        return fullName != false ? MONTH_FULL : MONTH_SHOT;
    }

    public static boolean matchWildcard(String value, String expr) {
        if (value == null) {
            return false;
        }
        if (expr == null) {
            return true;
        }
        String regExp = expr.replaceAll("\\*", ".*");
        return value.matches(regExp = regExp.replaceAll("\\?", "."));
    }

    public static String addLeadingCharacters(String word, String leadingStr, int numberOfCharacters) {
        int wordLength = ((String)word).length();
        if (wordLength < numberOfCharacters) {
            for (int i = 0; i < numberOfCharacters - wordLength; ++i) {
                word = leadingStr + (String)word;
            }
        }
        return word;
    }

    public static void moveFiles(File srcDir, File dstDir, String prefix) {
        File[] listOfFiles = srcDir.listFiles();
        if (listOfFiles == null) {
            return;
        }
        for (int i = 0; i < listOfFiles.length; ++i) {
            File fileToBeMoved;
            String fileNameToCheck;
            if (listOfFiles[i].isDirectory() || !(fileNameToCheck = (fileToBeMoved = listOfFiles[i]).getName()).startsWith(prefix)) continue;
            fileToBeMoved.renameTo(new File(dstDir, fileToBeMoved.getName()));
        }
    }

    public static int getFieldCount(String field) {
        if (!fieldCounters.containsKey(field)) {
            fieldCounters.put(field, 0);
        }
        int value = fieldCounters.get(field);
        fieldCounters.put(field, value + 1);
        return value;
    }

    public static void initFieldCounters() {
        fieldCounters = new HashMap();
    }

    public static ArrayList<String> stringToWords(String source, String delimiter, String quote, String escape) {
        return GlobalFunctions.stringToWords(source, delimiter, quote, escape, true);
    }

    public static ArrayList<String> stringToWords(String source, String delimiter, String quote, String escape, boolean suppressEmptyValue) {
        delimiter = delimiter == null ? " " : delimiter;
        quote = quote == null ? "\"" : quote;
        escape = escape == null ? "\\" : escape;
        ArrayList<String> toRet = new ArrayList<String>();
        boolean quoted = false;
        StringBuilder currWord = new StringBuilder();
        for (int i = 0; i < source.length(); ++i) {
            boolean escaped = false;
            if (escape.indexOf(source.charAt(i)) != -1 && !escaped) {
                escaped = true;
            }
            if (quote.indexOf(source.charAt(i)) != -1 && !escaped) {
                quoted = !quoted;
                continue;
            }
            if (delimiter.indexOf(source.charAt(i)) != -1 && !escaped && !quoted) {
                toRet.add(currWord.toString());
                currWord.delete(0, currWord.length());
                continue;
            }
            currWord.append(source.charAt(i));
        }
        if (currWord.length() > 0 || !suppressEmptyValue) {
            toRet.add(currWord.toString());
        }
        return toRet;
    }

    public static String getFirstDescendantTextByTagName(Element element, String tagName) throws DOMException {
        if (element == null || tagName == null || tagName.isEmpty()) {
            return null;
        }
        if (element.getElementsByTagName(tagName).getLength() > 0 && element.getElementsByTagName(tagName).item(0).getTextContent() != null) {
            Node node = element.getElementsByTagName(tagName).item(0);
            return node.getTextContent().trim();
        }
        return null;
    }

    public static ArrayList<String> getAllDescendantsTextByTagName(Element element, String tagName) throws DOMException {
        ArrayList<String> textList = new ArrayList<String>();
        if (element == null || tagName == null || tagName.isEmpty()) {
            return textList;
        }
        NodeList nodeList = element.getElementsByTagName(tagName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (!(childNode instanceof Element)) continue;
            String childText = childNode.getTextContent();
            textList.add(childText);
        }
        return textList;
    }

    public static Element getFirstChildElement(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Node childNode = nodeList.item(j);
            if (!(childNode instanceof Element)) continue;
            return (Element)childNode;
        }
        return null;
    }

    public static ArrayList<Element> getChildsElement(Element element) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            Node childNode = nodeList.item(j);
            if (!(childNode instanceof Element)) continue;
            elementList.add((Element)childNode);
        }
        return elementList;
    }

    public static ArrayList<String> getAllDescendantsAttributeByTagName(Element element, String tagName, String attributeName) {
        ArrayList<String> attrList = new ArrayList<String>();
        if (element == null || tagName == null || tagName.isEmpty() || attributeName == null || attributeName.isEmpty()) {
            return attrList;
        }
        NodeList nodeList = element.getElementsByTagName(tagName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (!(childNode instanceof Element) || !((Element)childNode).hasAttribute(attributeName)) continue;
            attrList.add(((Element)childNode).getAttribute(attributeName));
        }
        return attrList;
    }

    public static String join(ArrayList<String> list, String d) {
        int i;
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < list.size() - 1; ++i) {
            sb.append(list.get(i) + d);
        }
        return sb.toString() + list.get(i);
    }

    public static Element getFirstChildElementByTagName(Element element, String tagName) {
        if (element == null || tagName == null || tagName.isEmpty()) {
            return null;
        }
        if (element.getElementsByTagName(tagName).getLength() > 0) {
            element.getElementsByTagName(tagName).item(0);
            return (Element)element.getElementsByTagName(tagName).item(0);
        }
        return null;
    }

    public static String FullDayNameToCtmName(String firstDay) {
        String[] WeekDays = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"};
        for (int i = 0; i < WeekDays.length; ++i) {
            if (!firstDay.toUpperCase().startsWith(WeekDays[i].toString().toUpperCase())) continue;
            return WeekDays[i];
        }
        return null;
    }

    public static String EncodeXMLString(String orig_val) {
        if (orig_val == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < orig_val.length(); ++i) {
            char ch = orig_val.charAt(i);
            switch (ch) {
                case '&': {
                    sb.append("&amp;");
                    continue block10;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block10;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block10;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block10;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block10;
                }
                case '\n': {
                    sb.append("&#xA;");
                    continue block10;
                }
                case '\r': {
                    sb.append("&#xD;");
                    continue block10;
                }
                case '\t': {
                    sb.append("&#x9;");
                    continue block10;
                }
                default: {
                    if (Character.isISOControl(ch)) continue block10;
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String formatXml(String fullXml) {
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new ByteArrayInputStream(fullXml.getBytes("utf-8"))));
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", document, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                node.getParentNode().removeChild(node);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            transformer.setParameter("format-pretty-print", Boolean.TRUE);
            transformer.transform(new DOMSource(document), streamResult);
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
        return stringWriter.toString();
    }

    public static InputStream toInputStream(String input) {
        return new ByteArrayInputStream(input.getBytes());
    }

    public static <T extends Throwable> String getStackTraceStringFromException(T throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static boolean isRunningInDebugger() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("-agentlib:jdwp");
    }

    public static Date createSpecifcDate(int year, int month, int dayOfMonth) {
        LocalDate dateToConvert = LocalDate.of(year, month, dayOfMonth);
        return Date.from(dateToConvert.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static boolean isNotEmpty(String str) {
        return !str.isEmpty();
    }

    public static String getDraftFileName() {
        if (SettingsBooleanKeys.JSON_DRAFT_FORMAT.isEnabled()) {
            return "draft.json";
        }
        return "draft.xml";
    }

    public static List<String> getCalendarsFileName() {
        if (SettingsBooleanKeys.isSaas()) {
            return GlobalFunctions.getJsonCalendarFileNames();
        }
        return List.of(CALENDAR_XML_FILE);
    }

    public static List<String> getJsonCalendarFileNames() {
        return List.of(RBC_JSON_FILE, REGULAR_CALENDAR_JSON_FILE);
    }

    public static List<String> getTempCalendarFilePath() {
        String path = Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP;
        return GlobalFunctions.getCalendarsFileName().stream().map(path::concat).collect(Collectors.toList());
    }

    public static String replaceUnsupportedEMCharacters(String str) {
        return str.replaceAll("[\u201c\u201d]", "\"").replaceAll("[\u2019\u2018]", "'").replaceAll("[^\\x00-\\x7F]", "_");
    }

    public static void createDirectoryIfNotExist(String path) throws IOException {
        if (!GlobalFunctions.isDirExist(path)) {
            Path directoryPath = Paths.get(path, new String[0]);
            Files.createDirectories(directoryPath, new FileAttribute[0]);
        }
    }

    public static String escapeControlCharacters(String in) {
        String escapedStr = StringEscapeUtils.escapeJava((String)in);
        try {
            return new UnicodeUnescaper().translate((CharSequence)escapedStr);
        }
        catch (Exception e) {
            return escapedStr;
        }
    }

    public static <T> void forEachIndexed(Stream<T> items, ObjIntConsumer<T> action) {
        AtomicInteger index = new AtomicInteger();
        items.forEach(item -> action.accept(item, index.getAndIncrement()));
    }

    public static <T> void forEachIndexed(Collection<T> items, ObjIntConsumer<T> action) {
        GlobalFunctions.forEachIndexed(items.stream(), action);
    }

    public static String removeVariablePrefix(String variableName) {
        return variableName.replaceAll("^%%", "");
    }

    public static <T> OrElse ifPresent(T value, Consumer<? super T> consumer) {
        Optional optional = Optional.ofNullable(value);
        return OrElse.ifTrue(optional.isPresent(), () -> optional.ifPresent(consumer));
    }

    public static <T> void ifPresent(T value, Runnable runnable) {
        GlobalFunctions.ifPresent(value, (? super T ignored) -> runnable.run());
    }

    public static String toValidFilename(String filename) {
        return filename.replaceAll("[^a-zA-Z0-9\\.\\-]", "_");
    }

    public static boolean isBalancedParentheses(Collection<String> input) {
        ArrayDeque<String> stack = new ArrayDeque<String>();
        for (String value : input) {
            if ("(".equals(value)) {
                stack.push("");
                continue;
            }
            if (!")".equals(value)) continue;
            if (stack.isEmpty()) {
                return false;
            }
            stack.pop();
        }
        return stack.isEmpty();
    }

    public static boolean isPoolVariable(String variableName) {
        return variableName.matches("(%%)?\\\\\\\\.+?\\\\.+");
    }

    public static String removeQuotesIfNeeded(String name) {
        return name.replaceAll("^\"(.*)\"$", "$1");
    }

    public static String getControlMName() {
        if (SettingsBooleanKeys.isOnPremise()) {
            return Params.instance().getDatacenterName();
        }
        return "LocalControlM";
    }

    public static String addMissingVariablePrefix(String key) {
        if (key.startsWith("%%")) {
            return key;
        }
        return "%%" + key;
    }

    public static String replaceControlCharacters(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("[\\p{Cntrl}]", "");
    }

    public static boolean isSmartFolder(SchedEntity schedEntity) {
        return GlobalFunctions.isSmartFolder(schedEntity.type());
    }

    public static boolean isSmartFolder(SchedEntity.TYPE schedEntityType) {
        return schedEntityType.equals((Object)SchedEntity.TYPE.SMART_TABLE) || schedEntityType.equals((Object)SchedEntity.TYPE.SMART_FOLDER);
    }

    public static String shorten(String s, int maxLength) {
        return s.substring(0, Math.min(maxLength, s.length()));
    }

    public static <T> List<T> concatLists(List<T> left, List<T> right) {
        return Stream.concat(left.stream(), right.stream()).collect(Collectors.toList());
    }

    public static Optional<String> subStringOrEmpty(String str, int beginIndex, int endIndex) {
        return Optional.ofNullable(str).filter(s -> s.length() >= endIndex).map(it -> it.substring(beginIndex, endIndex));
    }

    public static boolean isUseParentSchedulingRbcName(String rbcName) {
        return rbcName.equals("*");
    }

    public static boolean isUseParentSchedulingRbc(Properties tag) {
        return GlobalFunctions.isUseParentSchedulingRbcName(tag.getProperty("NAME"));
    }

    public static String readText(InputStream input) {
        return new BufferedReader(new InputStreamReader(input)).lines().collect(Collectors.joining("\n"));
    }

    @NotNull
    public static Set<Properties> filterInheritableCalendars(Collection<Properties> calendars) {
        return calendars.stream().filter(calendar -> {
            String calendarName = calendar.getProperty("NAME");
            return !calendarName.startsWith("!") && !calendarName.equals("*");
        }).collect(Collectors.toSet());
    }

    public static boolean isStarOrExcludeCalendar(String calendarName) {
        return "*".equals(calendarName) || calendarName.startsWith("!");
    }

    public static boolean isIncludeCalendar(Properties calendar) {
        String calendarName = calendar.getProperty("NAME");
        return !GlobalFunctions.isStarOrExcludeCalendar(calendarName);
    }

    public static <T> T getLastItemOf(Collection<T> items) {
        ArrayList<T> accList = new ArrayList<T>(items);
        return accList.get(accList.size() - 1);
    }

    public static <T> Optional<T> getLastItemFrom(Collection<T> items) {
        if (!items.isEmpty()) {
            return Optional.ofNullable(GlobalFunctions.getLastItemOf(items));
        }
        return Optional.empty();
    }

    public static Map<String, String> attributesCyclicInterval(String timeFrom, String interval) {
        if (timeFrom != null) {
            return Map.of("CYCLIC", "1", "CYCLIC_TYPE", "Interval", "IND_CYCLIC", "T", "TIMEFROM", timeFrom, "INTERVAL", interval);
        }
        return Map.of("CYCLIC", "1", "CYCLIC_TYPE", "Interval", "IND_CYCLIC", "T", "INTERVAL", interval);
    }

    public static Map<String, String> attributesCyclicStartSequence(String timeSequence) {
        return Map.of("CYCLIC", "1", "CYCLIC_TYPE", "S", "IND_CYCLIC", "T", "CYCLIC_TIMES_SEQUENCE", timeSequence);
    }

    public static Map<String, String> attributesCyclicSpecificSequence(String timeSequence) {
        return Map.of("CYCLIC", "1", "CYCLIC_TYPE", "SpecificTimes", "IND_CYCLIC", "T", "CYCLIC_TIMES_SEQUENCE", timeSequence);
    }

    public static <T> Stream<T> streamFrom(Iterator<T> iterator) {
        return Stream.generate(() -> null).takeWhile(x -> iterator.hasNext()).map(x -> iterator.next());
    }
}

