/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.StreamGobbler;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ExternalCommand {
    public static final int SUCCSESS = 0;
    public static final int ERROR = 1;
    private Builder builder;
    private Process process;
    private ProcessBuilder processBuilder;
    private Integer exitValue;
    private StreamGobbler outputStreamGobbler;
    private StreamGobbler errorStreamGobbler;
    private StringBuilder cmdStr = new StringBuilder();
    private StringBuffer outputBuffer = null;

    private ExternalCommand(Builder builder) {
        this.builder = builder;
        this.initExternalCommand();
    }

    private void initExternalCommand() {
        Iterator<String> it = this.builder.commandArray.iterator();
        while (it.hasNext()) {
            String param = it.next();
            if (param == null || param.isEmpty() || param.matches("\\s+")) {
                it.remove();
                continue;
            }
            this.cmdStr.append("\" " + param + "\"");
        }
        if (this.builder.isScript && GlobalFunctions.isWindows()) {
            this.builder.commandArray = new ArrayList();
            this.builder.commandArray.add(0, "/c");
            this.builder.commandArray.add(0, "cmd");
            this.builder.commandArray.add(this.cmdStr.toString());
        }
        this.processBuilder = new ProcessBuilder(this.builder.commandArray);
        this.processBuilder.redirectErrorStream(this.builder.redirectErrToOut);
        if (this.builder.workingDirectoryFile != null) {
            this.processBuilder.directory(this.builder.workingDirectoryFile);
        }
    }

    public void start() {
        try {
            this.startThrows();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
            ConversionLogger.getLogger().info("Caught IOException: " + e.getMessage());
            this.exitValue = 1;
        }
        catch (InterruptedException e) {
            ExceptionHandler.writeToExceptionFile(e);
            ConversionLogger.getLogger().info("Caught InterruptedException: " + e.getMessage());
            this.exitValue = 1;
        }
    }

    public void startThrows() throws IOException, InterruptedException {
        this.process = this.processBuilder.start();
        this.runStreamGobbler();
        if (this.builder.waitFor) {
            this.exitValue = this.process.waitFor();
        }
        ConversionLogger.getLogger().info(this.toString());
    }

    private void runStreamGobbler() throws InterruptedException {
        this.outputBuffer = new StringBuffer();
        this.outputStreamGobbler = new StreamGobbler(this.process.getInputStream(), this.outputBuffer);
        if (this.builder.redirectOutputFile != null) {
            this.outputStreamGobbler.setOutputFile(this.builder.redirectOutputFile);
        }
        this.outputStreamGobbler.start();
        this.errorStreamGobbler = new StreamGobbler(this.process.getErrorStream(), this.outputBuffer);
        if (this.builder.redirectErrorFile == null) {
            this.errorStreamGobbler.setOutputFile(this.builder.redirectErrorFile);
        }
        this.errorStreamGobbler.start();
    }

    public Integer getExitValue() {
        return this.exitValue;
    }

    public String getOutputStdOut() {
        return this.getStream(this.outputStreamGobbler);
    }

    public String getOutputStdErr() {
        return this.getStream(this.errorStreamGobbler);
    }

    private String getStream(StreamGobbler streamGobbler) {
        String toRet = "";
        if (streamGobbler != null) {
            if (this.builder.waitFor) {
                try {
                    streamGobbler.join();
                }
                catch (Exception e) {
                    ExceptionHandler.writeToExceptionFile(e);
                }
            }
            toRet = streamGobbler.getStream();
        }
        return toRet;
    }

    public String toString() {
        String stdout;
        String commandArray = "External Command: " + this.builder.commandArray.toString() + " ";
        String workingDirectory = this.builder.workingDirectoryFile != null ? "\nWorking Directory: [" + this.builder.workingDirectoryFile.getPath() + "] " : " ";
        String stdin = this.builder.redirectInputFile != null ? "STDIN > " + this.builder.redirectInputFile.getPath() + " " : "";
        String string = stdout = this.builder.redirectOutputFile != null ? "STDOUT > " + this.builder.redirectOutputFile.getPath() : "";
        Object stderr = this.builder.redirectErrorFile != null ? "STDERR > " + this.builder.redirectErrorFile.getPath() + " " : (this.builder.redirectErrToOut ? " STDERR > STDOUT " : "");
        String redirection = stdin.isEmpty() && stdout.isEmpty() && ((String)stderr).isEmpty() ? "" : "\nRedirection: [" + stdin + stdout + (String)stderr + "]";
        String commandOutput = "\nStdout size: " + this.getOutputStdOut().length() + "\nStderr size: " + this.getOutputStdErr().length();
        String returnVal = this.exitValue != null ? "\nReturn Value: [ " + this.exitValue + " ] " : "";
        return commandArray + workingDirectory + redirection + commandOutput + returnVal;
    }

    public static class Builder {
        private ArrayList<String> commandArray;
        private boolean waitFor;
        private boolean isScript;
        private boolean redirectErrToOut;
        private File redirectInputFile;
        private File redirectOutputFile;
        private File redirectErrorFile;
        private File workingDirectoryFile;

        public Builder(String ... commandArray) {
            this.commandArray = new ArrayList<String>(Arrays.asList(commandArray));
        }

        public Builder(List<String> commandList) {
            this.commandArray = new ArrayList<String>(commandList);
        }

        public Builder(String command, Properties commandProperties) {
            this.commandArray = new ArrayList();
            this.commandArray.add(command);
            this.addPropertiesToCommandArray(commandProperties);
        }

        public Builder(String command1, String command2, Properties commandProperties) {
            this.commandArray = new ArrayList();
            this.commandArray.add(command1);
            this.commandArray.add(command2);
            this.addPropertiesToCommandArray(commandProperties);
        }

        private void addPropertiesToCommandArray(Properties commandProperties) {
            for (String key : commandProperties.stringPropertyNames()) {
                this.commandArray.add(key);
                this.commandArray.add(commandProperties.getProperty(key));
            }
        }

        public Builder redirectErrToOut(boolean redirectErrToOut) {
            this.redirectErrToOut = redirectErrToOut;
            return this;
        }

        public Builder redirectInputFromFile(File redirectInput) {
            this.redirectInputFile = redirectInput;
            return this;
        }

        public Builder redirectInputFromFile(String redirectInputPath) {
            this.redirectInputFile = new File(redirectInputPath);
            return this;
        }

        public Builder redirectOutputToFile(File redirectOutput) {
            this.redirectOutputFile = redirectOutput;
            return this;
        }

        public Builder redirectOutputToFile(String redirectOutputPath) {
            this.redirectOutputFile = new File(redirectOutputPath);
            return this;
        }

        public Builder redirectErrorToFile(File redirectError) {
            this.redirectErrorFile = redirectError;
            return this;
        }

        public Builder redirectErrorToFile(String redirectErrorPath) {
            this.redirectErrorFile = new File(redirectErrorPath);
            return this;
        }

        public Builder waitFor(boolean waitFor) {
            this.waitFor = waitFor;
            return this;
        }

        public Builder isScript(boolean isScript) {
            this.isScript = isScript;
            return this;
        }

        public Builder workingDirectory(String directoryPath) {
            this.workingDirectoryFile = new File(directoryPath);
            return this;
        }

        private void fixFilePaths() {
            if (this.redirectInputFile != null) {
                this.redirectInputFile = this.fixFilePath(this.redirectInputFile.getPath());
            }
            if (this.redirectOutputFile != null) {
                this.redirectOutputFile = this.fixFilePath(this.redirectOutputFile.getPath());
            }
            if (this.redirectErrorFile != null) {
                this.redirectErrorFile = this.fixFilePath(this.redirectErrorFile.getPath());
            }
        }

        private File fixFilePath(String filePath) {
            Object tmpPath = filePath;
            if (this.workingDirectoryFile != null && !((String)tmpPath).matches("^[a-zA-Z]:\\\\.*")) {
                tmpPath = this.workingDirectoryFile.getPath() + (((String)tmpPath).matches("^\\\\") ? "" : "\\") + (String)tmpPath;
            }
            return new File((String)tmpPath);
        }

        public ExternalCommand build() {
            this.fixFilePaths();
            return new ExternalCommand(this);
        }
    }
}

