/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class DateUtils {
    public static String DEFAULT_CONTROL_M_FORMAT = "yyyyMMdd";

    public static String transformDateFormat(String inputDate, String inputFormat, String outputFormat) {
        String retVal = "";
        LocalDate localDateRetVal = DateUtils.stringToLocalDateTransformer(inputDate, inputFormat);
        if (localDateRetVal != null) {
            retVal = DateUtils.calculateDate(localDateRetVal, outputFormat);
        }
        return retVal;
    }

    public static LocalDate stringToLocalDateTransformer(String inputDate, String dateFormat) {
        LocalDate localDateValue = null;
        if (inputDate != null && dateFormat != null) {
            localDateValue = DateUtils.getLocalDate(inputDate, dateFormat);
        }
        return localDateValue;
    }

    private static LocalDate getLocalDate(String inputDate, String dateFormat) {
        LocalDate retVal = null;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateFormat);
        try {
            retVal = LocalDate.parse(inputDate, formatter);
        }
        catch (DateTimeParseException tdpe) {
            ConversionLogger.getLogger().info("DateUtils.getLocalDate  - Wrong date format: " + dateFormat);
        }
        return retVal;
    }

    public static String calculateDate(LocalDate localDate, String outputFormat) {
        String retVal = "";
        if (localDate != null) {
            outputFormat = outputFormat == null ? DEFAULT_CONTROL_M_FORMAT : outputFormat;
            retVal = localDate.format(DateTimeFormatter.ofPattern(outputFormat));
        }
        return retVal;
    }
}

