/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.TextManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ConversionProcessSearcher {
    private final String taskListCommand = "tasklist";
    private final String filterFlag = "/fi";
    private final String filterByName = "windowtitle";
    private final String equal = "eq";
    private final String conversionExe = "javaw.exe";
    private final String selfConversionExe = "electron.exe";

    public ProcessStatus searchProcess(ProcessTag processTag) throws IOException {
        String name = this.getProcessFullName(processTag);
        String exeName = processTag.equals((Object)ProcessTag.Conversion) ? "javaw.exe" : "electron.exe";
        String[] cmdArray = new String[]{"tasklist", "/fi", "windowtitle eq " + name};
        Runtime runTime = Runtime.getRuntime();
        Process process = runTime.exec(cmdArray);
        InputStream inputStream = process.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String line = bufferedReader.readLine();
        int instanceCounter = 0;
        while (line != null) {
            if (line.contains(exeName)) {
                ++instanceCounter;
            }
            line = bufferedReader.readLine();
        }
        return instanceCounter >= 1 ? ProcessStatus.Running : ProcessStatus.NotRunning;
    }

    private String getProcessFullName(ProcessTag processTag) {
        if (processTag == ProcessTag.Conversion) {
            return TextManager.instance().get("CONVERSION_TOOL_TITLE");
        }
        return TextManager.instance().get("SELF_CONVERSION_TITLE");
    }

    public static enum ProcessTag {
        Conversion,
        SelfConversion;

    }

    public static enum ProcessStatus {
        Running,
        NotRunning;

    }
}

