/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base.table;

import com.bmc.ctmconvert.base.table.BaseTableHeaserGradientPanel;
import com.bmc.ctmconvert.base.table.CompoundIcon;
import com.bmc.ctmconvert.base.table.ITableFilter;
import com.bmc.ctmconvert.base.table.TableHeaderRenderer;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;

class FilterTableHeaderRenderer
extends TableHeaderRenderer {
    private static final long serialVersionUID = 1L;
    private ImageIcon icon;
    private final ITableFilter<?> tableFilter;
    private boolean rendererInit = true;
    private int originalHorizontalTextPosition;

    public FilterTableHeaderRenderer(ITableFilter<?> tableFilter) {
        this.tableFilter = tableFilter;
    }

    private Icon getFilterIcon() {
        if (this.icon == null) {
            this.icon = new ImageIcon(this.getClass().getResource("/img/funnel.png"));
            this.icon = new ImageIcon(this.icon.getImage().getScaledInstance(12, 12, 4));
        }
        return this.icon;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int modelColumn;
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        JLabel newLabel = new JLabel();
        if (this.rendererInit) {
            this.originalHorizontalTextPosition = label.getHorizontalTextPosition();
            this.rendererInit = false;
        }
        if (this.tableFilter.isFiltered(modelColumn = table.convertColumnIndexToModel(column))) {
            Icon originalIcon = label.getIcon();
            if (originalIcon == null) {
                label.setIcon(this.getFilterIcon());
            } else {
                label.setIcon(new CompoundIcon(this.getFilterIcon(), originalIcon));
            }
            label.setHorizontalTextPosition(11);
        } else {
            label.setHorizontalTextPosition(this.originalHorizontalTextPosition);
        }
        BaseTableHeaserGradientPanel jPanel = new BaseTableHeaserGradientPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.setPreferredSize(new Dimension(1, 22));
        newLabel.setText(label.getText());
        newLabel.setForeground(FlowGlobals.ConversionWhite);
        jPanel.add(newLabel);
        jPanel.add(Box.createHorizontalGlue());
        JPanel jPanelSpacer = new JPanel();
        jPanelSpacer.setPreferredSize(new Dimension(1, 22));
        jPanelSpacer.setMaximumSize(new Dimension(1, 22));
        jPanelSpacer.setMinimumSize(new Dimension(1, 22));
        jPanelSpacer.setBackground(FlowGlobals.ConversionLightBlue);
        jPanel.add(jPanelSpacer);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JLabel filterLabel = new JLabel();
        filterLabel.setIcon(this.getFilterIcon());
        jPanel.add(filterLabel);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        return jPanel;
    }
}

