/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base.table;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class BaseTableHeaderButton
extends JButton
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private ButtonState buttonState = ButtonState.DEFAULT;
    private Border defaultBorder;
    private Border disabledBorder;

    public BaseTableHeaderButton() {
        this.initializeBorders();
        this.addMouseListener(this);
        this.setContentAreaFilled(false);
        this.setForeground(new Color(0xFFFFFF));
    }

    private void initializeBorders() {
        CompoundBorder tableBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 1, new Color(21139)), BorderFactory.createMatteBorder(1, 1, 0, 0, new Color(8175850))), BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(80742)));
        Border buttonInnerEmptyBorder = BorderFactory.createEmptyBorder(2, 7, 2, 7);
        CompoundBorder disabledCompoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(12305609)), BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.defaultBorder = BorderFactory.createCompoundBorder(tableBorder, buttonInnerEmptyBorder);
        this.disabledBorder = BorderFactory.createCompoundBorder(disabledCompoundBorder, buttonInnerEmptyBorder);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        switch (this.buttonState.ordinal()) {
            case 0: {
                this.setBorder(this.defaultBorder);
                g2.setPaint(new GradientPaint(new Point(0, 0), new Color(3382494), new Point(0, this.getHeight()), new Color(156578)));
                break;
            }
            case 1: {
                this.setBorder(this.defaultBorder);
                g2.setPaint(new GradientPaint(new Point(0, 0), new Color(6078461), new Point(0, this.getHeight()), new Color(3841501)));
                break;
            }
            case 2: {
                this.setBorder(this.defaultBorder);
                g2.setPaint(new GradientPaint(new Point(0, 0), new Color(3382494), new Point(0, this.getHeight()), new Color(156578)));
                break;
            }
            case 3: {
                this.setBorder(this.disabledBorder);
                g2.setPaint(new GradientPaint(new Point(0, 0), new Color(0xF7F7F7), new Point(0, this.getHeight()), new Color(0xE0E0E0)));
                break;
            }
        }
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.dispose();
        super.paintComponent(g);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.buttonState = b ? ButtonState.DEFAULT : ButtonState.DISABLED;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.buttonState.equals((Object)ButtonState.DISABLED)) {
            this.buttonState = ButtonState.CLICK;
            this.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.buttonState.equals((Object)ButtonState.DISABLED)) {
            this.buttonState = ButtonState.DEFAULT;
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.buttonState.equals((Object)ButtonState.DISABLED)) {
            this.buttonState = ButtonState.HOVER;
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (!this.buttonState.equals((Object)ButtonState.DISABLED)) {
            this.buttonState = ButtonState.DEFAULT;
            this.repaint();
        }
    }

    private static enum ButtonState {
        DEFAULT,
        HOVER,
        CLICK,
        DISABLED;

    }
}

