/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base.list;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class BaseItem
extends BaseComponent {
    protected JPanel itemPanel;
    protected boolean selected;
    protected Properties data;
    protected int lineHeight = 18;
    protected boolean enabled = true;
    protected ArrayList<ItemComponent> itemComponents;
    protected boolean isMouseInListItem;

    public BaseItem(Properties data) {
        this.data = data;
        this.init();
    }

    public BaseItem(String name) {
        this.componentName = name;
        this.data = new Properties();
        this.init();
    }

    private void init() {
        this.itemPanel = new JPanel();
        this.itemComponents = new ArrayList();
        this.itemPanel.setLayout(new BoxLayout(this.itemPanel, 0));
        this.itemPanel.add(Box.createRigidArea(new Dimension(10, this.lineHeight)));
        this.itemPanel.setBackground(FlowGlobals.ConversionWhite);
        this.itemPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (!BaseItem.this.ismouseExitFromPanelArea(e)) {
                    return;
                }
                BaseItem.this.handleMouseIsOut(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                BaseItem.this.isMouseInListItem = true;
                for (ItemComponent component : BaseItem.this.itemComponents) {
                    if (component.getVisibleState().equals((Object)Visible.NEVER)) continue;
                    component.setVisible(true);
                }
                if (BaseItem.this.enabled) {
                    BaseItem.this.itemPanel.setBackground(FlowGlobals.ConversionMenuSelectionRollover);
                }
            }
        });
    }

    private boolean ismouseExitFromPanelArea(MouseEvent e) {
        int clickX = e.getXOnScreen();
        int clickY = e.getYOnScreen();
        int panelWidth = this.itemPanel.getWidth();
        int panelHeight = this.itemPanel.getHeight();
        double panelX = this.itemPanel.getLocationOnScreen().getX();
        double panely = this.itemPanel.getLocationOnScreen().getY();
        return (double)clickX < panelX || (double)clickX >= panelX + (double)panelWidth || (double)clickY < panely || (double)clickY >= panely + (double)panelHeight;
    }

    public void handleMouseIsOut(MouseEvent e) {
        if (!this.ismouseExitFromPanelArea(e)) {
            return;
        }
        this.setMouseOut();
    }

    public void setMouseOut() {
        this.isMouseInListItem = false;
        for (ItemComponent component : this.itemComponents) {
            if (!component.getVisibleState().equals((Object)Visible.MOUSEOVER_ONLY)) continue;
            component.setVisible(false);
        }
        if (this.enabled) {
            this.itemPanel.setBackground(FlowGlobals.ConversionWhite);
        }
    }

    @Override
    public Component getComponent() {
        return this.itemPanel;
    }

    public void addMouseListener(MouseListener l) {
        this.itemPanel.addMouseListener(l);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setSelected(boolean aFlag) {
        this.selected = aFlag;
    }

    @Override
    public Properties getData() {
        return this.data;
    }

    public class ItemComponent {
        private Component component;
        private Component invisebleComponent;
        private JPanel componentPanel;
        private Visible visibleState = Visible.MOUSEOVER_ONLY;

        public ItemComponent(BaseItem this$0, Component component) {
            this.componentPanel = new JPanel();
            this.componentPanel.setSize(new Dimension(component.getWidth(), component.getHeight()));
            this.componentPanel.setOpaque(false);
            this.componentPanel.setLayout(new BoxLayout(this.componentPanel, 0));
            this.component = component;
            this.invisebleComponent = Box.createRigidArea(new Dimension(component.getWidth(), component.getHeight()));
            this.componentPanel.add(this.invisebleComponent);
            this.componentPanel.add(component);
            this.setVisible(true);
            this.init();
        }

        public Visible getVisibleState() {
            return this.visibleState;
        }

        public ItemComponent(BaseItem this$0) {
            this.init();
        }

        private void init() {
            this.visibleState = Visible.MOUSEOVER_ONLY;
        }

        public void setVisible(Boolean b) {
            this.invisebleComponent.setVisible(b == false);
            this.componentPanel.removeAll();
            if (b.booleanValue()) {
                this.componentPanel.add(this.component);
            } else {
                this.componentPanel.add(this.invisebleComponent);
            }
        }

        public Component getComponent() {
            return this.componentPanel;
        }

        public void setVisibleState(Visible visibleState) {
            this.visibleState = visibleState;
        }
    }

    public static enum Visible {
        ALLWAYS,
        MOUSEOVER_ONLY,
        NEVER;

    }
}

