/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.FlowGlobalsStrings;
import com.bmc.ctmconvert.common.TextManager;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class ButtonFactory {
    public static BaseButton createButton(ButtonType buttonType) {
        return ButtonFactory.createButton(buttonType, null);
    }

    public static BaseButton createEnterSensitiveButton(ButtonType buttonType) {
        return ButtonFactory.createEnterSensitiveButton(buttonType, null);
    }

    public static BaseButton createEnterSensitiveButton(ButtonType buttonType, ActionListener actionListener) {
        BaseButton button = ButtonFactory.createButton(buttonType, actionListener);
        button.getInputMap(0).put(KeyStroke.getKeyStroke("ENTER"), "enter");
        button.getActionMap().put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((BaseButton)e.getSource()).doClick();
            }
        });
        return button;
    }

    public static BaseButton createButton(ButtonType buttonType, ActionListener actionListener) {
        String tooltip;
        String text;
        String tooltipText;
        BaseButton button = new BaseButton();
        button.setIconTextGap(5);
        button.setEnabled(true);
        button.addActionListener(actionListener);
        switch (buttonType.ordinal()) {
            case 56: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_LOAD_DATA_STR"));
                button.setMnemonic(76);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_LOAD_DATA_STR"));
                break;
            }
            case 57: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_RELOAD_DATA_STR"));
                button.setMnemonic(82);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_RELOAD_DATA_STR"));
                break;
            }
            case 18: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_DETACH_STR"));
                button.setIcon(new ImageIcon(ButtonFactory.class.getResource("/img/Detach-16.png")));
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_DETACH_STR"));
                button.setMnemonic(79);
                button.setToolTipText(TextManager.instance().get("MAIN_NAVIGATION_DETACH_STR"));
                break;
            }
            case 3: {
                button.setIcon(new ImageIcon(ButtonFactory.class.getResource(FlowGlobals.HELP_ICON)));
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_HELP_STR"));
                button.setFocusable(false);
                break;
            }
            case 55: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_AGREE"));
                button.setMnemonic(65);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_AGREE"));
                break;
            }
            case 0: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_CREATE_NEW"));
                button.setMnemonic(67);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_CREATE_NEW"));
                button.setPreferredSize(new Dimension(120, 40));
                break;
            }
            case 1: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_CREATE"));
                button.setMnemonic(67);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_CREATE"));
                break;
            }
            case 17: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_IMPORT"));
                button.setMnemonic(73);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_IMPORT"));
                break;
            }
            case 49: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_YES_STR"));
                button.setMnemonic(89);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_YES_STR"));
                break;
            }
            case 50: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_NO_STR"));
                button.setMnemonic(78);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_NO_STR"));
                break;
            }
            case 53: {
                button.setText(TextManager.instance().get("MANUAL_FILES_IMPORT"));
                button.setMnemonic(65);
                button.setActionCommand(TextManager.instance().get("MANUAL_FILES_IMPORT"));
                break;
            }
            case 54: {
                button.setText(TextManager.instance().get("STOP_DISCOVERY"));
                button.setMnemonic(83);
                button.setActionCommand(TextManager.instance().get("STOP_DISCOVERY"));
                break;
            }
            case 51: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_OVERWIRTE_STR"));
                button.setMnemonic(79);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_OVERWIRTE_STR"));
                break;
            }
            case 45: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_APPLY_STR"));
                button.setMnemonic(65);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_APPLY_STR"));
                break;
            }
            case 46: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_APPLY_N_CLOSE"));
                button.setMnemonic(65);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_APPLY_N_CLOSE"));
                break;
            }
            case 47: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_RESET"));
                button.setMnemonic(82);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_RESET"));
                break;
            }
            case 48: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_FIELD_EDITOR_MENU"));
                button.setMnemonic(77);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_FIELD_EDITOR_MENU"));
                button.setToolTipText(TextManager.instance().get("MAIN_NAVIGATION_FIELD_EDITOR_MENU_TOOLTIP"));
                break;
            }
            case 2: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_HELP_STR"));
                button.setFocusable(false);
                button.setMnemonic(72);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_HELP_STR"));
                break;
            }
            case 4: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_VERIFICATION_STR"));
                button.setFocusable(false);
                button.setMnemonic(86);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_VERIFICATION_STR"));
                button.setToolTipText(TextManager.instance().get("MAIN_NAVIGATION_VERIFICATION_TOOLTIP"));
                break;
            }
            case 5: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_NEXT_STR"));
                button.setMnemonic(78);
                button.setEnabled(false);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_NEXT_STR"));
                break;
            }
            case 6: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_BACK_STR"));
                button.setMnemonic(66);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_BACK_STR"));
                break;
            }
            case 7: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_QUIT_STR"));
                button.setMnemonic(81);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_QUIT_STR"));
                break;
            }
            case 8: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_FINISH_STR"));
                button.setMnemonic(70);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_FINISH_STR"));
                break;
            }
            case 9: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_SAVE_STR"));
                button.setMnemonic(83);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_SAVE_STR"));
                break;
            }
            case 15: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_SAVE_AS_STR"));
                button.setMnemonic(83);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_SAVE_AS_STR"));
                break;
            }
            case 10: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_OK_STR"));
                button.setMnemonic(79);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_OK_STR"));
                break;
            }
            case 11: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_SKIP_STR"));
                button.setMnemonic(83);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_SKIP_STR"));
                break;
            }
            case 12: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_CANCEL_STR"));
                button.setMnemonic(67);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_CANCEL_STR"));
                break;
            }
            case 13: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_OPEN_STR"));
                button.setMnemonic(79);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_OPEN_STR"));
                break;
            }
            case 14: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"));
                button.setMnemonic(67);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"));
                break;
            }
            case 19: {
                button.setIcon(new ImageIcon(ButtonFactory.class.getResource("/img/Open-16.png")));
                button.setText(TextManager.instance().get("CAPTURE_DATA_EXPORT_STR"));
                button.setMnemonic(69);
                button.setActionCommand(TextManager.instance().get("CAPTURE_DATA_EXPORT_STR"));
                break;
            }
            case 20: {
                button.setIcon(new ImageIcon(ButtonFactory.class.getResource(FlowGlobals.STATUS_ICON_CRITICAL_URL)));
                button.setText(TextManager.instance().get("CAPTURE_DATA_DELETE_STR"));
                button.setMnemonic(68);
                button.setActionCommand(TextManager.instance().get("CAPTURE_DATA_DELETE_STR"));
                button.setEnabled(false);
                break;
            }
            case 21: {
                button.setIcon(new ImageIcon(ButtonFactory.class.getResource("/img/Edit-16.png")));
                button.setText(TextManager.instance().get("CAPTURE_DATA_EDIT_STR"));
                button.setMnemonic(68);
                button.setActionCommand(TextManager.instance().get("CAPTURE_DATA_EDIT_STR"));
                break;
            }
            case 16: {
                button.setIcon(FlowGlobals.ADD_ICON);
                button.setText(TextManager.instance().get("CAPTURE_DATA_ADD_STR"));
                button.setMnemonic(65);
                button.setActionCommand(TextManager.instance().get("CAPTURE_DATA_ADD_STR"));
                button.setEnabled(false);
                break;
            }
            case 35: {
                button.setIcon(new ImageIcon(ButtonFactory.class.getResource("/img/Folder-open-16.png")));
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_BROWSE_STR"));
                button.setPreferredSize(new Dimension(FlowGlobals.fieldSize.height, FlowGlobals.fieldSize.height));
                break;
            }
            case 22: {
                button.setIcon(new ImageIcon(ButtonFactory.class.getResource("/img/Edit-16.png")));
                button.setMnemonic(69);
                button.setActionCommand(TextManager.instance().get("CAPTURE_DATA_EDIT_STR"));
                break;
            }
            case 23: {
                button.setIcon(new ImageIcon(ButtonFactory.class.getResource("/img/Edit-16.png")));
                button.setMnemonic(69);
                button.setActionCommand(TextManager.instance().get("CAPTURE_DATA_EDIT_STR"));
                button.setTransparent(true);
                break;
            }
            case 26: {
                button.setIcon(FlowGlobals.ADD_ICON);
                button.setActionCommand(TextManager.instance().get("CAPTURE_DATA_ADD_STR"));
                button.setTransparent(true);
                button.setFocusable(false);
                break;
            }
            case 27: {
                button.setIcon(FlowGlobals.STATUS_ICON_CRITICAL);
                button.setMnemonic(68);
                button.setActionCommand(TextManager.instance().get("CAPTURE_DATA_DELETE_STR"));
                button.setTransparent(true);
                button.setFocusable(false);
                break;
            }
            case 24: {
                button.setIcon(new ImageIcon(ButtonFactory.class.getResource("/img/Report-16.png")));
                button.setText(TextManager.instance().get("CAPTURE_DATA_ASSESSMENT_REPORT_STR"));
                button.setMnemonic(86);
                button.setEnabled(false);
                button.setActionCommand(TextManager.instance().get("CAPTURE_DATA_ASSESSMENT_REPORT_STR"));
                break;
            }
            case 25: {
                button.setIcon(new ImageIcon(ButtonFactory.class.getResource("/img/Report-16.png")));
                button.setText(TextManager.instance().get("CAPTURE_DATA_CONVERSION_REPORT_STR"));
                button.setMnemonic(86);
                button.setEnabled(false);
                button.setActionCommand(TextManager.instance().get("CAPTURE_DATA_CONVERSION_REPORT_STR") + "CMD");
                break;
            }
            case 28: {
                button.setIcon(new ImageIcon(ButtonFactory.class.getResource("/img/Report-16.png")));
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_VALIDATE_STR"));
                button.setMnemonic(86);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_VALIDATE_STR"));
                break;
            }
            case 29: {
                button.setIcon(new ImageIcon(ButtonFactory.class.getResource("/img/icon_Forecast.png")));
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_VALIDATE_REPORT_STR"));
                button.setMnemonic(86);
                button.setEnabled(true);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_VALIDATE_REPORT_STR"));
                break;
            }
            case 30: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_DISCOVER_STR"));
                button.setMnemonic(70);
                button.setEnabled(false);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_DISCOVER_STR"));
                break;
            }
            case 31: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_SHOW_DETAILS_STR"));
                button.setMnemonic(68);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_SHOW_DETAILS_STR"));
                break;
            }
            case 32: {
                button.setText(TextManager.instance().get("MAIN_NAVIGATION_COPY_TO_CLIPBOARD_STR"));
                button.setMnemonic(67);
                button.setActionCommand(TextManager.instance().get("MAIN_NAVIGATION_COPY_TO_CLIPBOARD_STR"));
                break;
            }
            case 34: {
                button.setText(TextManager.instance().get("CAPTURE_DATA_TEST_CONNECTION_STR"));
                button.setMnemonic(84);
                button.setActionCommand(TextManager.instance().get("CAPTURE_DATA_TEST_CONNECTION_STR"));
                break;
            }
            case 52: {
                button.setText(TextManager.instance().get("CAPTURE_DATA_TEST_STR"));
                button.setMnemonic(84);
                button.setActionCommand(TextManager.instance().get("CAPTURE_DATA_TEST_STR"));
                break;
            }
            case 36: {
                button.setText(TextManager.instance().get("VALIDATION_REPORT_START"));
                button.setActionCommand(TextManager.instance().get("VALIDATION_REPORT_START"));
                break;
            }
            case 37: {
                button.setText(TextManager.instance().get("VALIDATION_REPORT_PREV_MONTH"));
                button.setActionCommand(TextManager.instance().get("VALIDATION_REPORT_PREV_MONTH"));
                break;
            }
            case 38: {
                button.setText(TextManager.instance().get("VALIDATION_REPORT_NEXT_MONTH"));
                button.setActionCommand(TextManager.instance().get("VALIDATION_REPORT_NEXT_MONTH"));
                break;
            }
            case 39: {
                button.setText(TextManager.instance().get("VALIDATION_REPORT_PREV_YEAR"));
                button.setActionCommand(TextManager.instance().get("VALIDATION_REPORT_PREV_YEAR"));
                break;
            }
            case 40: {
                button.setText(TextManager.instance().get("VALIDATION_REPORT_NEXT_YEAR"));
                button.setActionCommand(TextManager.instance().get("VALIDATION_REPORT_NEXT_YEAR"));
                break;
            }
            case 41: {
                button.setText(TextManager.instance().get("VALIDATION_REPORT_END"));
                button.setActionCommand(TextManager.instance().get("VALIDATION_REPORT_END"));
                break;
            }
            case 42: {
                button.setText(TextManager.instance().get("VALIDATION_REPORT_TODAY"));
                button.setActionCommand(TextManager.instance().get("VALIDATION_REPORT_TODAY"));
                break;
            }
            case 43: {
                button.setText(TextManager.instance().get("BUTTON_TEXT_GENERATE_SCRIPT"));
                button.setMnemonic(71);
                button.setActionCommand(TextManager.instance().get("BUTTON_TEXT_GENERATE_SCRIPT"));
                break;
            }
            case 44: {
                button.setText(TextManager.instance().get("BUTTON_TEXT_GENERATE_SCRIPT").trim() + "s");
                button.setMnemonic(71);
                button.setActionCommand(TextManager.instance().get("BUTTON_TEXT_GENERATE_SCRIPT") + "s");
                break;
            }
            case 33: {
                String clipboardButtonText = TextManager.instance().get("FIELD_LOAD_COPY_TO_CLIPBOARD_BUTTON");
                button.setText(clipboardButtonText);
                button.setMnemonic(67);
                button.setActionCommand(clipboardButtonText);
                button.setToolTipText(clipboardButtonText);
                break;
            }
        }
        if (button.getIcon() == null) {
            button.setIconTextGap(0);
            button.setIcon(FlowGlobals.TRANSPARENT_ICON);
        }
        if (!((tooltipText = button.getToolTipText()) != null && !tooltipText.isEmpty() || (text = button.getText()) == null || text.isEmpty() || (tooltip = FlowGlobalsStrings.Tooltips.get(text)) == null || tooltip.isEmpty())) {
            button.setToolTipText(tooltip);
        }
        return button;
    }

    public static enum ButtonType {
        NEW_PROJECT,
        CREATE,
        HELP,
        HELP_ICON_ONLY,
        VERIFICATION,
        NEXT,
        BACK,
        QUIT,
        FINISH,
        SAVE,
        OK,
        SKIP,
        CANCEL,
        OPEN,
        CLOSE,
        SAVE_AS,
        ADD,
        IMPORT_DATA,
        DETACH,
        EXPORT,
        DELETE,
        EDIT,
        EDIT_ICON_ONLY,
        EDIT_ICON_WITHOUT_BORDER,
        ASSESSMENT_REPORT,
        CONVERSION_REPORT,
        ADD_ICON_ONLY,
        DELETE_ICON_ONLY,
        VALIDATE,
        VALIDATE_REPORT,
        DISCOVER,
        VIEW_DETILS,
        COPY_TO_CLIPBOARD,
        COPY_DRAFT_XML_TO_CLIPBOARD,
        TEST_CONNECTION,
        BROWSE,
        START,
        PREV_MONTH,
        NEXT_MONTH,
        PREV_YEAR,
        NEXT_YEAR,
        END,
        TODAY,
        GENERATE,
        GENERATE_SCRIPTS,
        APPLY,
        APPLY_N_CLOSE,
        RESET,
        FIELD_EDITOR_MENU,
        YES,
        NO,
        OVERWIRTE,
        TEST,
        MANUAL_DISCOVERY,
        STOP_DISCOVERY,
        AGREE,
        LOAD_DATA,
        RELOAD_DATA;

    }
}

