/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class BaseWaterMarkTextField
extends BaseComponent
implements FocusListener {
    private BaseTextField baseTextField;
    private String waterMarkText;

    public BaseWaterMarkTextField(String text) {
        this.waterMarkText = text;
        this.baseTextField = new BaseTextField(text);
        this.initialize();
    }

    public BaseWaterMarkTextField(BaseFieldValidator validator) {
        this.waterMarkText = "";
        this.baseTextField = new BaseTextField(validator);
        this.initialize();
    }

    public BaseWaterMarkTextField(String text, BaseFieldValidator validator) {
        this.waterMarkText = text;
        this.baseTextField = new BaseTextField(text, validator);
        this.initialize();
    }

    public BaseWaterMarkTextField(String text, String name, String groupName) {
        this(text);
        this.componentName = name;
        this.componentGroup = groupName;
    }

    private void initialize() {
        this.baseTextField.addValidityListener(this);
        this.baseTextField.getComponent().addFocusListener(this);
        this.setWaterMark(true);
    }

    @Override
    public Component getValidityComponent() {
        return this.baseTextField.getValidityComponent();
    }

    @Override
    public void setValidityLook(boolean valid) {
        this.baseTextField.setValidityLook(valid);
    }

    @Override
    public void setValidConstrain() {
        this.baseTextField.setValidConstrain();
    }

    public void setWaterMarkText(String text) {
        this.waterMarkText = text;
        this.setWaterMark(true);
    }

    private void setWaterMark(boolean b) {
        if (b) {
            this.baseTextField.getComponent().setForeground(Color.LIGHT_GRAY);
            this.baseTextField.getComponent().setFont(FlowGlobals.FONT_STYLE_ITALIC);
            this.baseTextField.setText(this.waterMarkText);
        } else {
            this.baseTextField.getComponent().setForeground(Color.BLACK);
            this.baseTextField.getComponent().setFont(FlowGlobals.FONT_STYLE_REGULAR);
            this.baseTextField.setText("");
        }
    }

    public void setText(String text) {
        if (text == null) {
            return;
        }
        if (!text.isEmpty() && !text.equals(this.waterMarkText)) {
            this.setWaterMark(false);
        }
        this.baseTextField.setText(text);
    }

    public String getText() {
        return this.baseTextField.getText();
    }

    @Override
    public boolean isValid() {
        return this.baseTextField.isValid();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.baseTextField.getText().equalsIgnoreCase(this.waterMarkText)) {
            this.setWaterMark(false);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.baseTextField.getText().isEmpty()) {
            this.setWaterMark(true);
        }
    }

    @Override
    public Object getData() {
        return this.baseTextField.getData();
    }

    @Override
    public void setData(Object data) {
        if (!(data instanceof String)) {
            return;
        }
        this.setText((String)data);
    }

    @Override
    public DataRetrievable.DataType getDataType() {
        return this.baseTextField.getDataType();
    }

    @Override
    public void setActive(Boolean b) {
        this.baseTextField.setActive(b);
    }

    @Override
    public void addValueChangedAction(Actionable action) {
        this.baseTextField.addValueChangedAction(action);
    }

    @Override
    public Component getComponent() {
        return this.baseTextField.getComponent();
    }
}

