/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.base.table.BaseTableHeaderButton;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.Table;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BaseTableAddRemoveWrapper
extends BaseComponent
implements DataRetrievable {
    private JPanel jPanel;
    private JPanel jPanelButtons;
    private JTable jTable;
    private BaseButton add;
    private BaseButton delete;
    private BaseButton[] buttonsArray;
    private boolean enabled = true;

    public BaseTableAddRemoveWrapper(JTable jTable) {
        this.jTable = jTable;
        this.initializeButtonArray();
        this.initialize();
    }

    public BaseTableAddRemoveWrapper(JTable jTable, String componentName, String componentGroupName) {
        this.componentGroup = componentGroupName;
        this.componentName = componentName;
        this.jTable = jTable;
        this.initializeButtonArray();
        this.initialize();
    }

    public BaseTableAddRemoveWrapper(JTable jTable, BaseButton[] buttonsArray) {
        this.jTable = jTable;
        this.buttonsArray = buttonsArray;
        this.initialize();
    }

    private void initializeButtonArray() {
        this.add = ButtonFactory.createButton(ButtonFactory.ButtonType.ADD_ICON_ONLY, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BaseTableAddRemoveWrapper.this.jTable.isEditing()) {
                    BaseTableAddRemoveWrapper.this.jTable.getCellEditor().stopCellEditing();
                }
                DefaultTableModel tableModel = (DefaultTableModel)BaseTableAddRemoveWrapper.this.jTable.getModel();
                int columnsCount = tableModel.getColumnCount();
                Object[] tmp = new Object[columnsCount];
                for (int i = 0; i < columnsCount; ++i) {
                    tmp[i] = "";
                }
                tableModel.insertRow(0, tmp);
            }
        });
        this.delete = ButtonFactory.createButton(ButtonFactory.ButtonType.DELETE_ICON_ONLY, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BaseTableAddRemoveWrapper.this.jTable != null) {
                    if (BaseTableAddRemoveWrapper.this.jTable.isEditing()) {
                        BaseTableAddRemoveWrapper.this.jTable.getCellEditor().stopCellEditing();
                    }
                    DefaultTableModel tableModel = (DefaultTableModel)BaseTableAddRemoveWrapper.this.jTable.getModel();
                    int row = BaseTableAddRemoveWrapper.this.jTable.getSelectedRow();
                    if (row != -1) {
                        tableModel.removeRow(row);
                    }
                }
            }
        });
        this.buttonsArray = new BaseButton[]{this.add, this.delete};
    }

    @Override
    public void addFocusListener(FocusListener l) {
        final FocusListener focus = l;
        final FocusEvent focusEvent = new FocusEvent(this.jTable, 1);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                focus.focusGained(focusEvent);
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(this){

            @Override
            public void mouseClicked(MouseEvent e) {
                focus.focusGained(focusEvent);
            }
        };
        this.jPanel.addFocusListener(focus);
        this.delete.addActionListener(actionListener);
        this.add.addActionListener(actionListener);
        this.jTable.addMouseListener(mouseAdapter);
        this.jTable.getTableHeader().addMouseListener(mouseAdapter);
    }

    private void initialize() {
        this.jPanel = new JPanel();
        this.jPanel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, new Color(11451073)));
        this.jPanel.setLayout(new BorderLayout());
        this.jPanel.setFocusable(true);
        this.jPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                BaseTableAddRemoveWrapper.this.jPanel.requestFocus();
            }
        });
        this.jPanelButtons = new JPanel();
        this.jPanelButtons.setBorder(BorderFactory.createEmptyBorder(3, 7, 3, 7));
        this.jPanelButtons.setBackground(FlowGlobals.ConversionGray);
        this.jPanelButtons.setLayout(new BoxLayout(this.jPanelButtons, 0));
        if (this.buttonsArray != null && this.buttonsArray.length > 0) {
            for (BaseButton button : this.buttonsArray) {
                this.jPanelButtons.add(button);
                this.jPanelButtons.add(Box.createRigidArea(new Dimension(5, 0)));
            }
            this.jPanel.add((Component)this.jPanelButtons, "North");
        }
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BorderLayout());
        TableColumnModel columnModel = this.jTable.getColumnModel();
        JTableHeader header = this.jTable.getTableHeader();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderRenderer(new TableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    BaseTableHeaderButton button = new BaseTableHeaderButton();
                    button.setText(value == null ? "" : value.toString());
                    button.setEnabled(BaseTableAddRemoveWrapper.this.enabled);
                    return button;
                }
            });
            columnModel.getColumn(i).setCellRenderer(new TableCellRenderer(this){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = table.prepareRenderer(table.getDefaultRenderer(StringBuilder.class), row, column);
                    if (table.isEnabled()) {
                        component.setForeground(FlowGlobals.ConversionBlack);
                    } else {
                        component.setForeground(FlowGlobals.ConversionDisableColor);
                    }
                    if (isSelected && table.isEnabled()) {
                        component.setBackground(new Color(8832748));
                        component.setForeground(FlowGlobals.ConversionWhite);
                    } else if (row % 2 == 0) {
                        component.setBackground(new Color(0xEBEBEB));
                    } else {
                        component.setBackground(FlowGlobals.ConversionWhite);
                    }
                    return component;
                }
            });
        }
        header.setReorderingAllowed(false);
        this.jTable.setSelectionMode(0);
        this.jTable.setFillsViewportHeight(true);
        this.jTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        tablePanel.add((Component)header, "North");
        tablePanel.add((Component)this.jTable, "Center");
        this.jPanel.add((Component)tablePanel, "Center");
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        for (BaseButton button : this.buttonsArray) {
            button.setEnabled(enabled);
        }
        this.jTable.setEnabled(enabled);
        this.jTable.setForeground(enabled ? null : Color.GRAY);
        this.jTable.getTableHeader().setForeground(enabled ? null : Color.GRAY);
        this.jTable.updateUI();
    }

    @Override
    public Component getComponent() {
        return this.jPanel;
    }

    @Override
    public Object getData() {
        if (!this.jPanel.isEnabled()) {
            return null;
        }
        return new Table(this.jTable.getModel());
    }

    @Override
    public void setData(Object data) {
        if (!this.jPanel.isEnabled()) {
            return;
        }
        Vector<Vector<String>> newDataVector = new Vector();
        JTableHeader header = this.jTable.getTableHeader();
        TableColumnModel columns = header.getColumnModel();
        Vector<String> columnsVector = new Vector<String>();
        int y = columns.getColumnCount();
        for (int i = 0; i < y; ++i) {
            TableColumn tc = columns.getColumn(i);
            columnsVector.add((String)tc.getHeaderValue());
        }
        if (data instanceof String[][]) {
            String[][] dataArray = (String[][])data;
            for (i = 0; i < dataArray.length; ++i) {
                rowVector = new Vector<String>();
                for (int j = 0; j < dataArray[i].length; ++j) {
                    if (dataArray[i][j] == null) continue;
                    rowVector.add(dataArray[i][j]);
                }
                if (rowVector.isEmpty()) continue;
                newDataVector.add(rowVector);
            }
        } else if (data instanceof TableModel) {
            newDataVector = new Table((TableModel)data).getRows();
        } else if (data instanceof Table) {
            Table dataTable = (Table)data;
            for (i = 0; i < dataTable.getRowCount(); ++i) {
                rowVector = new Vector();
                for (int j = 0; j < dataTable.getColumnCount(); ++j) {
                    if (dataTable.getValueAt(i, j) == null) continue;
                    rowVector.add(dataTable.getValueAt(i, j));
                }
                if (rowVector.isEmpty()) continue;
                newDataVector.add(rowVector);
            }
        } else if (data instanceof ArrayList) {
            ArrayList dataArray = (ArrayList)data;
            for (Object obj : dataArray) {
                Vector<String> rowVector = new Vector<String>();
                if (obj != null && obj instanceof String) {
                    rowVector.add((String)obj);
                    newDataVector.add(rowVector);
                    continue;
                }
                if (obj != null && obj instanceof ArrayList) {
                    ArrayList list = (ArrayList)obj;
                    for (Object listItem : list) {
                        if (listItem == null || !(listItem instanceof String)) continue;
                        rowVector.add((String)listItem);
                    }
                    if (rowVector.isEmpty()) continue;
                    newDataVector.add(rowVector);
                    continue;
                }
                if (obj == null || !(obj instanceof Map.Entry)) continue;
                Map.Entry entry = (Map.Entry)obj;
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (key instanceof String) {
                    rowVector.add((String)key);
                }
                if (value instanceof String) {
                    rowVector.add((String)value);
                }
                if (rowVector.isEmpty()) continue;
                newDataVector.add(rowVector);
            }
        } else if (data instanceof HashMap) {
            HashMap dataMap = (HashMap)data;
            for (Object key : dataMap.keySet()) {
                Vector<String> rowVector = new Vector<String>(2);
                Object value = dataMap.get(key);
                if (key == null || !(key instanceof String) || value == null || !(value instanceof String)) continue;
                rowVector.add((String)key);
                rowVector.add((String)value);
                newDataVector.add(rowVector);
            }
        }
        this.setTableDataWithoutEvents(this.jTable, newDataVector, columnsVector);
    }

    private void setTableDataWithoutEvents(JTable table, Vector<Vector<String>> newDataVector, Vector<String> columnsVector) {
        TableModelListener[] listeners;
        DefaultTableModel tableModel = (DefaultTableModel)this.jTable.getModel();
        for (TableModelListener tableModelListener : listeners = tableModel.getTableModelListeners()) {
            tableModel.removeTableModelListener(tableModelListener);
        }
        if (this.jTable.getSelectedRow() >= 0 && this.jTable.getSelectedColumn() >= 0) {
            this.jTable.getCellEditor(this.jTable.getSelectedRow(), this.jTable.getSelectedColumn()).stopCellEditing();
        }
        tableModel.setDataVector(newDataVector, columnsVector);
        for (TableModelListener tableModelListener : listeners) {
            tableModel.addTableModelListener(tableModelListener);
        }
    }

    @Override
    public void addValueChangedAction(Actionable action) {
        final Actionable tmpAction = action;
        DefaultTableModel tableModel = (DefaultTableModel)this.jTable.getModel();
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                tmpAction.act();
            }
        });
    }

    @Override
    public DataRetrievable.DataType getDataType() {
        return DataRetrievable.DataType.TABLE;
    }

    @Override
    public void setActive(Boolean b) {
        this.setEnabled(b);
    }
}

