/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.plaf.basic.BasicArrowButton;

public class BaseSplitButton
extends JButton
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton mainButton;
    private JButton dropDownButton;
    private JPopupMenu dropDownMenu;

    public BaseSplitButton() {
        this.mainButton = new BaseButton();
        this.initialize();
    }

    public BaseSplitButton(JButton button) {
        this.mainButton = button;
        this.initialize();
    }

    private void initialize() {
        this.dropDownButton = new BasicArrowButton(5);
        this.dropDownButton.addActionListener(this);
        this.setPreferredSize(new Dimension(42, 22));
        this.setMaximumSize(new Dimension(75, 34));
        this.setMinimumSize(new Dimension(200, 34));
        this.setLayout(new BorderLayout());
        this.setMargin(new Insets(-2, -3, -3, -3));
        this.add((Component)this.mainButton, "Center");
        this.add((Component)this.dropDownButton, "East");
    }

    @Override
    public void setIcon(Icon defaultIcon) {
        this.mainButton.setIcon(defaultIcon);
    }

    public void setMenu(JPopupMenu menu) {
        this.dropDownMenu = menu;
        this.dropDownMenu.setInvoker(this.mainButton);
    }

    public JButton getMainButton() {
        return this.mainButton;
    }

    public JButton getDropDownButton() {
        return this.dropDownButton;
    }

    public JPopupMenu getMenu() {
        return this.dropDownMenu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.dropDownMenu == null) {
            return;
        }
        if (!this.dropDownMenu.isVisible()) {
            Point p = this.getLocationOnScreen();
            this.dropDownMenu.setLocation((int)p.getX(), (int)p.getY() + this.getHeight());
            this.dropDownMenu.setVisible(true);
        } else {
            this.dropDownMenu.setVisible(false);
        }
    }

    @Override
    public void addActionListener(ActionListener al) {
        this.mainButton.addActionListener(al);
    }
}

