/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class BaseSimpleWaterMarkTextField
extends BaseComponent
implements FocusListener {
    private JTextField jTextField;
    private String waterMarkText;
    private Border border;

    public BaseSimpleWaterMarkTextField(String text) {
        this.waterMarkText = text;
        this.jTextField = new JTextField(text);
        this.initialize();
    }

    private void initialize() {
        this.border = FlowGlobals.fieldTextGapDefaultBorder;
        this.jTextField.addFocusListener(this);
        this.setWaterMark(true);
    }

    public void setWaterMarkText(String text) {
        this.waterMarkText = text;
        this.setWaterMark(true);
    }

    private void setWaterMark(boolean b) {
        if (this.border != null) {
            this.jTextField.setBorder(b ? FlowGlobals.fieldTextGapDefaultBorder : FlowGlobals.fieldTextGapSelectedBorder);
        }
        if (b) {
            this.jTextField.setForeground(Color.LIGHT_GRAY);
            this.jTextField.setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE_ITALIC);
            this.jTextField.setText(this.waterMarkText);
        } else {
            this.jTextField.setForeground(Color.BLACK);
            this.jTextField.setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE_REGULAR);
            this.jTextField.setText("");
        }
    }

    public String getText() {
        if (this.jTextField.getText().equalsIgnoreCase(this.waterMarkText)) {
            return "";
        }
        return this.jTextField.getText();
    }

    public void setText(String text) {
        if (text == null || text.isEmpty() || text.equalsIgnoreCase(this.waterMarkText)) {
            this.setWaterMark(true);
        } else {
            this.setWaterMark(false);
            this.jTextField.setText(text);
        }
    }

    public void setBorder(Border border) {
        this.border = border;
        this.jTextField.setBorder(border);
    }

    public void requestFocusInWindow() {
        this.jTextField.requestFocusInWindow();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.jTextField.getText().equalsIgnoreCase(this.waterMarkText)) {
            this.setWaterMark(false);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.jTextField.getText().isEmpty()) {
            this.setWaterMark(true);
        }
    }

    @Override
    public Component getComponent() {
        return this.jTextField;
    }
}

