/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseCheckBox;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BasePopupMenu;
import com.bmc.ctmconvert.base.BaseTextArea;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ClipboardManager;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.DialogFactory;
import com.bmc.ctmconvert.base.ValidityListener;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.TextManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class BaseMessageDialog
implements ActionListener {
    protected JDialog jDialog;
    private int width = 330;
    private int height = 130;
    protected boolean optionValue;
    protected static boolean okDefaultValue;
    private int confirmWithCancelValue;
    protected String optionString;
    private int saveAsOverwriteValue;
    private String[] saveValues;
    private static BaseFieldValidator.VALIDATOR_TYPE nameValidator;
    private String messages;
    private JTextPane jTextPane;
    protected static String checkBoxMsg;
    protected static boolean checkBoxCheked;
    private BaseCheckBox checkBoxVersionCheck;
    private BaseButton OKButton;
    private BaseButton skipButton;
    private BaseButton optionButton;
    private BaseButton YesButton;
    private BaseButton NoButton;
    BaseButton SaveButton;
    private BaseButton SaveAsButton;
    private BaseButton OverwriteButton;
    private BaseButton CancelButton;
    private BaseTextField nameField;
    private BaseTextArea descriptionField;
    private BaseButton show;
    public static final int CANCEL = 0;
    public static final int SAVE_AS = 1;
    public static final int OVERWRITE = 2;
    public static final int NO = 1;
    public static final int YES = 2;
    public static final int NAME = 0;
    public static final int DESCRIPTION = 1;

    protected BaseMessageDialog(Boolean optionValue, String optionString, String messages) {
        this.optionValue = optionValue != null ? optionValue : false;
        this.optionString = optionString;
        this.messages = messages;
    }

    private BaseMessageDialog(String title, String message, TYPE type, String option, Boolean optionValue, String messages) {
        this(title, message, type, option, optionValue, messages, null);
    }

    private BaseMessageDialog(String title, String message, TYPE type, String option, Boolean optionValue, String messages, String initialNameValue) {
        this(title, message, type, option, optionValue, messages, initialNameValue, false);
    }

    private BaseMessageDialog(String title, String message, TYPE type, String option, Boolean optionValue, String messages, String initialNameValue, boolean showDetails) {
        this(optionValue, option, messages);
        this.initialize(title, message, type);
        if (initialNameValue != null) {
            this.nameField.setText(initialNameValue);
        }
        if (showDetails) {
            this.show.doClick();
        }
    }

    public void show() {
        this.jDialog.setVisible(true);
    }

    public static boolean isCheckBoxCheked() {
        return checkBoxCheked;
    }

    public JDialog getComponent() {
        return this.jDialog;
    }

    public static boolean showConfirmDialog(String title, String message) {
        BaseMessageDialog messageDialog = new BaseMessageDialog(title, message, TYPE.CONFIRM_MESSAGE, null, null, null);
        messageDialog.show();
        return messageDialog.getOptionValue();
    }

    public static int showConfirmWithCancelDialog(String title, String message) {
        BaseMessageDialog messageDialog = new BaseMessageDialog(title, message, TYPE.CONFIRM_WITH_CANCEL_MESSAGE, null, null, null);
        messageDialog.show();
        return messageDialog.getConfirmWithCancelValue();
    }

    public static String[] showSaveDialog(String title, BaseFieldValidator.VALIDATOR_TYPE nameValidator) {
        BaseMessageDialog.nameValidator = nameValidator;
        BaseMessageDialog messageDialog = new BaseMessageDialog(title, null, TYPE.SAVE, null, null, null);
        messageDialog.show();
        return messageDialog.getSaveValues();
    }

    public static String[] showSaveWithDescriptionDialog(String title, String initialValue, BaseFieldValidator.VALIDATOR_TYPE nameValidator) {
        BaseMessageDialog.nameValidator = nameValidator;
        BaseMessageDialog messageDialog = new BaseMessageDialog(title, null, TYPE.SAVE_WITH_DESCRIPTION, null, null, null, initialValue);
        messageDialog.show();
        return messageDialog.getSaveValues();
    }

    public static boolean showMessageDialog(String title, String message, TYPE type) {
        okDefaultValue = true;
        BaseMessageDialog messageDialog = new BaseMessageDialog(title, message, type, null, null, null);
        messageDialog.show();
        return messageDialog.getOptionValue();
    }

    public static boolean showMessageDialog(String title, String message, TYPE type, String messages) {
        okDefaultValue = true;
        BaseMessageDialog messageDialog = new BaseMessageDialog(title, message, type, null, null, messages);
        messageDialog.show();
        return messageDialog.getOptionValue();
    }

    public static boolean showMessageDialog(String title, String message, TYPE type, String messages, boolean showDetails) {
        okDefaultValue = true;
        BaseMessageDialog messageDialog = new BaseMessageDialog(title, message, type, null, null, messages, null, showDetails);
        messageDialog.show();
        return messageDialog.getOptionValue();
    }

    void setDialogResizePolicy() {
        this.jDialog.setResizable(false);
    }

    protected void initialize(String title, String message, TYPE type) {
        this.setJdialogSettings(title);
        Container contentPane = this.jDialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBackground(FlowGlobals.ConversionWhite);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 15, 20, 15));
        JPanel messagePanel = this.buildMessagePanelByType(message, type);
        mainPanel.add((Component)messagePanel, "Center");
        this.addPanelsToDialogContent(contentPane, mainPanel, this.getFooterPanel(type));
        this.jDialog.pack();
        this.requestButtonFocusByType(type);
        this.width = this.checkBoxVersionCheck != null ? this.checkBoxVersionCheck.getComponent().getWidth() + 120 : contentPane.getSize().width + 16;
        this.height = contentPane.getSize().height + 28;
        int minWidth = this.getMinWidth();
        int minHeight = this.getMinHeight();
        this.jDialog.setMinimumSize(new Dimension(minWidth, minHeight));
        this.jDialog.setLocationRelativeTo(SwingUtilities.getRoot(this.jDialog.getParent()));
    }

    private JPanel buildMessagePanelByType(String message, TYPE type) {
        JPanel messagePanel = new JPanel();
        messagePanel.setBackground(FlowGlobals.ConversionWhite);
        if (type.equals((Object)TYPE.SAVE) || type.equals((Object)TYPE.SAVE_WITH_DESCRIPTION)) {
            this.saveTypeCase(messagePanel, type);
        } else {
            this.otherTypesCase(messagePanel, message, type);
        }
        return messagePanel;
    }

    protected void otherTypesCase(JPanel messagePanel, String message, TYPE type) {
        messagePanel.setLayout(new FlowLayout(3));
        JLabel iconLabel = new JLabel(BaseMessageDialog.getImageIconByType(type));
        messagePanel.add(iconLabel);
        messagePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        JTextArea messageArea = new JTextArea(message);
        ((JComponent)messageArea).setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
        messageArea.setEditable(false);
        messageArea.setBackground(FlowGlobals.ConversionWhite);
        messagePanel.add(messageArea);
    }

    private void requestButtonFocusByType(TYPE type) {
        if (type.equals((Object)TYPE.CONFIRM_MESSAGE)) {
            this.NoButton.requestFocus();
        } else if (type.equals((Object)TYPE.CONFIRM_WITH_CANCEL_MESSAGE)) {
            this.YesButton.requestFocus();
        } else if (type.equals((Object)TYPE.SAVE_AS_OVERRIDE)) {
            this.CancelButton.requestFocus();
        } else if (type.equals((Object)TYPE.SAVE) || type.equals((Object)TYPE.SAVE_WITH_DESCRIPTION)) {
            this.nameField.getComponent().requestFocus();
        } else if (this.optionString != null) {
            this.optionButton.requestFocus();
        } else {
            this.OKButton.requestFocus();
        }
    }

    private void saveTypeCase(JPanel messagePanel, TYPE type) {
        GridBagLayout grid = new GridBagLayout();
        int[] columnWidths = new int[]{10, 100, 20, FlowGlobals.fieldSize.width, 5, 25};
        grid.columnWidths = columnWidths;
        messagePanel.setLayout(grid);
        GridBagConstraints gridConstraints = new GridBagConstraints();
        gridConstraints.anchor = 19;
        gridConstraints.fill = 2;
        JLabel mandatoryLabel = new JLabel("*");
        mandatoryLabel.setForeground(Color.RED);
        gridConstraints.gridx = 0;
        gridConstraints.gridy = 0;
        messagePanel.add((Component)mandatoryLabel, gridConstraints);
        JLabel name = new JLabel(TextManager.instance().get("BASE_MESSAGE_DIALOG_NAME") + ":");
        name.setFont(FlowGlobals.FONT_STYLE_REGULAR);
        gridConstraints.gridx = 1;
        gridConstraints.gridy = 0;
        messagePanel.add((Component)name, gridConstraints);
        this.nameField = new BaseTextField(new BaseFieldValidator(nameValidator));
        this.nameField.addValidityListener(new ValidityListener(){

            @Override
            public void validityActionPerformed(ConversionEvent e) {
                BaseMessageDialog.this.SaveButton.setEnabled(e.getValue());
            }
        });
        gridConstraints.gridx = 2;
        gridConstraints.gridy = 0;
        messagePanel.add(this.nameField.getValidityComponent(), gridConstraints);
        gridConstraints.gridx = 3;
        gridConstraints.gridy = 0;
        messagePanel.add(this.nameField.getComponent(), gridConstraints);
        if (type.equals((Object)TYPE.SAVE_WITH_DESCRIPTION)) {
            gridConstraints.insets = new Insets(8, 0, 0, 0);
            JLabel description = new JLabel(TextManager.instance().get("BASE_MESSAGE_DIALOG_DESCRIPTION") + ":");
            description.setFont(FlowGlobals.FONT_STYLE_REGULAR);
            gridConstraints.gridx = 1;
            gridConstraints.gridy = 1;
            messagePanel.add((Component)description, gridConstraints);
            this.descriptionField = new BaseTextArea();
            gridConstraints.gridx = 3;
            gridConstraints.gridy = 1;
            messagePanel.add(this.descriptionField.getComponent(), gridConstraints);
            gridConstraints.gridx = 5;
            messagePanel.add(this.descriptionField.getExtraComponent(), gridConstraints);
        }
    }

    private void setJdialogSettings(String title) {
        this.jDialog = DialogFactory.instance().getLinkedDialog();
        this.jDialog.setModal(true);
        this.jDialog.setTitle(title);
        this.setDialogResizePolicy();
        this.jDialog.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(FlowGlobals.BMC_ICON_PATH)));
        this.jDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                BaseMessageDialog.this.windowClosingActions();
            }
        });
        InputMap inputMap = this.jDialog.getRootPane().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.jDialog.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseMessageDialog.this.windowClosingActions();
            }
        });
    }

    protected int getMinWidth() {
        return this.width;
    }

    protected int getMinHeight() {
        return this.height;
    }

    void addPanelsToDialogContent(Container dialogContent, JPanel messagePanel, JPanel footerPanel) {
        dialogContent.add((Component)messagePanel, "North");
        dialogContent.add((Component)footerPanel, "Center");
    }

    private void windowClosingActions() {
        if (this.optionString != null) {
            this.optionValue = false;
        }
        this.dialogCloseAction();
    }

    public static Icon getImageIconByType(TYPE type) {
        ImageIcon icon = null;
        switch (type.ordinal()) {
            case 2: {
                icon = new ImageIcon(BaseMessageDialog.class.getResource(FlowGlobals.DIALOG_STATUS_ICON_OK));
                break;
            }
            case 0: {
                icon = new ImageIcon(BaseMessageDialog.class.getResource(FlowGlobals.DIALOG_STATUS_ICON_CRITICAL));
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                icon = new ImageIcon(BaseMessageDialog.class.getResource(FlowGlobals.DIALOG_STATUS_ICON_WARNING));
                break;
            }
            case 4: 
            case 11: {
                icon = new ImageIcon(BaseMessageDialog.class.getResource(FlowGlobals.DIALOG_STATUS_ICON_INFORMATION));
                break;
            }
            case 5: 
            case 8: {
                icon = new ImageIcon(BaseMessageDialog.class.getResource(FlowGlobals.HELP_ICON_PATH));
                break;
            }
        }
        return icon;
    }

    protected JPanel getFooterPanel(TYPE type) {
        JPanel footerPanel = new JPanel();
        footerPanel.setLayout(new BorderLayout());
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setPreferredSize(new Dimension(this.width, 50));
        buttonsPanel.setBackground(FlowGlobals.ConversionGray);
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        if (this.messages != null && !this.messages.isEmpty()) {
            final JPanel messagesContainerPanel = new JPanel();
            messagesContainerPanel.setLayout(new BorderLayout());
            this.jTextPane = new JTextPane();
            this.jTextPane.setFont(FlowGlobals.FONT_STYLE_REGULAR);
            SimpleAttributeSet set = new SimpleAttributeSet();
            StyleConstants.setLineSpacing(set, 0.2f);
            this.jTextPane.setParagraphAttributes(set, false);
            this.jTextPane.setBorder(null);
            this.jTextPane.setBackground(FlowGlobals.fieldDefaultBackground);
            this.jTextPane.setEditable(false);
            this.jTextPane.setCursor(Cursor.getPredefinedCursor(2));
            this.jTextPane.addMouseListener(new ContextListener());
            this.jTextPane.setText(this.messages);
            final JScrollPane jScrollPane = new JScrollPane(this.jTextPane);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 10, 10, 9), FlowGlobals.customLowerBorder));
            jScrollPane.setBackground(FlowGlobals.fieldDefaultBackground);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jScrollPane.getVerticalScrollBar().setValue(0);
                }
            });
            messagesContainerPanel.add((Component)jScrollPane, "Center");
            JPanel messagesFooterPanel = new JPanel();
            messagesFooterPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            messagesFooterPanel.setBackground(FlowGlobals.fieldDefaultBackground);
            messagesFooterPanel.setLayout(new BoxLayout(messagesFooterPanel, 0));
            BaseButton copy = ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.COPY_TO_CLIPBOARD, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClipboardManager.instance().setClipboardContents(BaseMessageDialog.this.messages);
                }
            });
            messagesFooterPanel.add(Box.createHorizontalGlue());
            messagesFooterPanel.add(copy);
            messagesFooterPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            messagesContainerPanel.add((Component)messagesFooterPanel, "South");
            messagesContainerPanel.setVisible(false);
            footerPanel.add((Component)messagesContainerPanel, "Center");
            this.show = ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.VIEW_DETILS);
            int messagesHeght = 200;
            this.show.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (messagesContainerPanel.isVisible()) {
                        BaseMessageDialog.this.jDialog.setResizable(false);
                        BaseMessageDialog.this.show.setText(TextManager.instance().get("MAIN_NAVIGATION_SHOW_DETAILS_STR"));
                        BaseMessageDialog.this.jDialog.setSize(new Dimension(BaseMessageDialog.this.width, BaseMessageDialog.this.height));
                        messagesContainerPanel.setVisible(false);
                    } else {
                        BaseMessageDialog.this.show.setText(TextManager.instance().get("MAIN_NAVIGATION_HIDE_DETAILS_STR"));
                        BaseMessageDialog.this.jDialog.setResizable(true);
                        BaseMessageDialog.this.jDialog.setSize(new Dimension(BaseMessageDialog.this.width, BaseMessageDialog.this.height + 200));
                        messagesContainerPanel.setVisible(true);
                    }
                }
            });
            buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            buttonsPanel.add(this.show);
            buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        }
        if (type.equals((Object)TYPE.CONFIRM_MESSAGE) || type.equals((Object)TYPE.CONFIRM_WITH_CANCEL_MESSAGE)) {
            buttonsPanel.add(Box.createHorizontalGlue());
            buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            this.YesButton = ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.YES, this);
            buttonsPanel.add(this.YesButton);
            buttonsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.NoButton = ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.NO, this);
            buttonsPanel.add(this.NoButton);
            if (type.equals((Object)TYPE.CONFIRM_WITH_CANCEL_MESSAGE)) {
                buttonsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
                this.CancelButton = ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.CANCEL, this);
                buttonsPanel.add(this.CancelButton);
            }
            buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        } else if (type.equals((Object)TYPE.SAVE_AS_OVERRIDE)) {
            buttonsPanel.add(Box.createHorizontalGlue());
            buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            this.SaveAsButton = ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.SAVE_AS, this);
            buttonsPanel.add(this.SaveAsButton);
            buttonsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.OverwriteButton = ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.OVERWIRTE, this);
            buttonsPanel.add(this.OverwriteButton);
            buttonsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.CancelButton = ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.CANCEL, this);
            buttonsPanel.add(this.CancelButton);
            buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        } else if (type.equals((Object)TYPE.SAVE) || type.equals((Object)TYPE.SAVE_WITH_DESCRIPTION)) {
            buttonsPanel.add(Box.createHorizontalGlue());
            buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            this.SaveButton = ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.SAVE, this);
            this.SaveButton.setEnabled(false);
            buttonsPanel.add(this.SaveButton);
            buttonsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            this.CancelButton = ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.CANCEL, this);
            buttonsPanel.add(this.CancelButton);
            buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        } else {
            if (this.optionString != null) {
                buttonsPanel.add(Box.createHorizontalGlue());
                this.optionButton = ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.ASSESSMENT_REPORT, this);
                if (this.optionString.equals(TextManager.instance().get("CAPTURE_DATA_IMPORT_ENDED_DIALOG_OPTION"))) {
                    this.optionButton = ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.ASSESSMENT_REPORT, this);
                } else if (this.optionString.equals(TextManager.instance().get("CONVERSION_PANEL_CONVERSION_ENDED_DIALOG_OPTION"))) {
                    this.optionButton = ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.CONVERSION_REPORT, this);
                }
                this.optionButton.setEnabled(true);
                buttonsPanel.add(this.optionButton);
                buttonsPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            } else if (type.equals((Object)TYPE.CONFIRM_CHECKBOX) || type.equals((Object)TYPE.CONFIRM_CHECKBOX_WITH_SKIP)) {
                this.checkBoxVersionCheck = new BaseCheckBox(checkBoxMsg);
                this.checkBoxVersionCheck.setBackground(FlowGlobals.ConversionGray);
                this.checkBoxVersionCheck.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        checkBoxCheked = BaseMessageDialog.this.checkBoxVersionCheck.isSelected();
                    }
                });
                this.checkBoxVersionCheck.setSelected(checkBoxCheked);
                buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
                buttonsPanel.add(this.checkBoxVersionCheck.getComponent());
                buttonsPanel.add(Box.createHorizontalGlue());
            } else {
                buttonsPanel.add(Box.createHorizontalGlue());
            }
            this.OKButton = ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.OK, this);
            buttonsPanel.add(this.OKButton);
            buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            if (type.equals((Object)TYPE.CONFIRM_CHECKBOX_WITH_SKIP)) {
                this.skipButton = ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.SKIP, this);
                buttonsPanel.add(this.skipButton);
                buttonsPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            }
        }
        footerPanel.add((Component)buttonsPanel, "South");
        return footerPanel;
    }

    public boolean getOptionValue() {
        return this.optionValue;
    }

    public void setOptionValue(boolean b) {
        this.optionValue = b;
    }

    public int getSaveAsOverwriteValue() {
        return this.saveAsOverwriteValue;
    }

    public int getConfirmWithCancelValue() {
        return this.confirmWithCancelValue;
    }

    public void setSaveAsOverwriteValue(int val) {
        this.saveAsOverwriteValue = val;
    }

    public String[] getSaveValues() {
        return this.saveValues;
    }

    protected void dialogCloseAction() {
        this.jDialog.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(TextManager.instance().get("MAIN_NAVIGATION_YES_STR"))) {
            this.optionValue = true;
            this.confirmWithCancelValue = 2;
            this.dialogCloseAction();
        } else if (action.equals(TextManager.instance().get("MAIN_NAVIGATION_NO_STR"))) {
            this.optionValue = false;
            this.confirmWithCancelValue = 1;
            this.dialogCloseAction();
        } else if (action.equals(TextManager.instance().get("MAIN_NAVIGATION_OK_STR"))) {
            this.optionValue = okDefaultValue;
            this.dialogCloseAction();
        } else if (action.equals(TextManager.instance().get("MAIN_NAVIGATION_SKIP_STR"))) {
            this.optionValue = !okDefaultValue;
            this.dialogCloseAction();
        } else if (action.equals(TextManager.instance().get("MAIN_NAVIGATION_SAVE_AS_STR"))) {
            this.setSaveAsOverwriteValue(1);
            this.dialogCloseAction();
        } else if (action.equals(TextManager.instance().get("MAIN_NAVIGATION_OVERWIRTE_STR"))) {
            this.setSaveAsOverwriteValue(2);
            this.dialogCloseAction();
        } else if (action.equals(TextManager.instance().get("MAIN_NAVIGATION_CANCEL_STR"))) {
            this.setSaveAsOverwriteValue(0);
            this.confirmWithCancelValue = 0;
            this.saveValues = null;
            this.dialogCloseAction();
        } else if (action.equals(TextManager.instance().get("MAIN_NAVIGATION_SAVE_STR"))) {
            this.saveValues = new String[2];
            this.saveValues[0] = this.nameField.getText();
            if (this.descriptionField != null) {
                this.saveValues[1] = this.descriptionField.getText();
            }
            this.dialogCloseAction();
        } else if (action.equals(TextManager.instance().get("CAPTURE_DATA_CONVERSION_REPORT_STR") + "CMD") || action.equals(TextManager.instance().get("CAPTURE_DATA_ASSESSMENT_REPORT_STR"))) {
            this.optionValue = true;
            this.dialogCloseAction();
        }
    }

    public void setNameText(String text) {
        this.nameField.setText(text);
    }

    static {
        checkBoxMsg = "";
        checkBoxCheked = false;
    }

    public static enum TYPE {
        ERROR_MESSAGE,
        WARNING_MESSAGE,
        SUCCESS_MESSAGE,
        PLAIN_MESSAGE,
        INFORMATION_MESSAGE,
        QUESTION_MESSAGE,
        CONFIRM_MESSAGE,
        CONFIRM_WITH_CANCEL_MESSAGE,
        SAVE_AS_OVERRIDE,
        SAVE,
        SAVE_WITH_DESCRIPTION,
        CONFIRM_CHECKBOX,
        CONFIRM_CHECKBOX_WITH_SKIP;

    }

    public final class ContextListener
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPop(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPop(e);
            }
        }

        private void doPop(MouseEvent e) {
            BasePopupMenu contextMenu = new BasePopupMenu();
            JMenuItem menuItem = new JMenuItem(TextManager.instance().get("BASE_MESSAGE_DIALOG_COPY"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String text = BaseMessageDialog.this.jTextPane.getSelectedText();
                    ClipboardManager.instance().setClipboardContents(text != null ? text : "");
                }
            });
            contextMenu.add(menuItem);
            contextMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public final class ContextMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;
    }

    public final class TextTransfer
    implements ClipboardOwner {
        public TextTransfer(BaseMessageDialog this$0) {
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }
}

