/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseRadioButton;
import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;

public class BaseButtonGroup
extends BaseComponent {
    private ButtonGroup buttonGroup;
    private JLabel groupLable;
    Actionable changedAction;

    public BaseButtonGroup() {
        this.init();
    }

    public BaseButtonGroup(String componentName, String componentGroup, String componentTitle) {
        this.groupLable = new JLabel(componentTitle + (componentTitle != null && !componentTitle.isEmpty() ? ":" : ""));
        this.init();
        this.componentName = componentName;
        this.componentGroup = componentGroup;
    }

    private void init() {
        this.buttonGroup = new ButtonGroup();
        this.validityMessageImage = new JLabel(FlowGlobals.FIELD_VALIDATION_ERROR_ICON);
        this.validityMessageImage.setVisible(false);
    }

    public void add(BaseRadioButton b) {
        this.buttonGroup.add((AbstractButton)b.getComponent());
    }

    @Override
    public void addValueChangedAction(Actionable action) {
        this.changedAction = action;
        Enumeration<AbstractButton> buttuns = this.buttonGroup.getElements();
        while (buttuns.hasMoreElements()) {
            AbstractButton button = buttuns.nextElement();
            if (button == null) {
                System.out.println("itai button group updateData - null" + String.valueOf(button));
            }
            final Actionable myAction = action;
            button.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    myAction.act();
                }
            });
        }
    }

    @Override
    public void setError(Boolean b, String Message2) {
        this.setValidityLook(b == false);
    }

    public void add(BaseRadioButton b, String buttonName) {
        this.buttonGroup.add((AbstractButton)b.getComponent());
        ((AbstractButton)b.getComponent()).setName(buttonName);
        ((AbstractButton)b.getComponent()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                BaseButtonGroup.this.changedAction.act();
            }
        });
    }

    @Override
    public Object getData() {
        Enumeration<AbstractButton> buttuns = this.buttonGroup.getElements();
        while (buttuns.hasMoreElements()) {
            AbstractButton button = buttuns.nextElement();
            if (!button.isSelected()) continue;
            return button.getName();
        }
        return null;
    }

    @Override
    public void setData(Object obj) {
        if (!(obj instanceof String)) {
            return;
        }
        String selectedButtonID = (String)obj;
        Enumeration<AbstractButton> buttuns = this.buttonGroup.getElements();
        while (buttuns.hasMoreElements()) {
            AbstractButton button = buttuns.nextElement();
            if (button == null) {
                System.out.println("itai button group updateData - null" + String.valueOf(button));
            }
            if (!button.getName().equals(selectedButtonID)) continue;
            this.buttonGroup.setSelected(button.getModel(), true);
        }
    }

    @Override
    public DataRetrievable.DataType getDataType() {
        return DataRetrievable.DataType.STRING;
    }

    @Override
    public void setActive(Boolean b) {
        Enumeration<AbstractButton> buttuns = this.buttonGroup.getElements();
        while (buttuns.hasMoreElements()) {
            AbstractButton button = buttuns.nextElement();
            if (button == null) {
                System.out.println("itai button group updateData - null" + String.valueOf(button));
            }
            button.setEnabled(b);
        }
    }

    @Override
    public Component getComponent() {
        return this.groupLable;
    }

    @Override
    public void setValidityLook(boolean valid) {
        this.validityMessageImage.setVisible(!valid);
        this.validityMessageImage.setToolTipText(valid ? "" : "eror");
    }
}

