/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.base.DescriptionListener;
import com.bmc.ctmconvert.base.Errorable;
import com.bmc.ctmconvert.base.NavegationListener;
import com.bmc.ctmconvert.base.ValidityListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public abstract class Base
implements ValidityListener,
DataRetrievable,
Errorable {
    private String command;
    protected EventListenerList listenerList = new EventListenerList();
    protected boolean isValid;
    protected String componentName;
    protected String componentGroup;
    protected boolean isActive = true;
    private ArrayList<Actionable> valueChangedActionsList = new ArrayList();

    public synchronized void addValidityListener(ValidityListener l) {
        this.addListener(ValidityListener.class, l);
    }

    public synchronized void removeValidityListener(ValidityListener l) {
        this.listenerList.remove(ValidityListener.class, l);
    }

    public synchronized void addNavegationListener(NavegationListener l) {
        this.addListener(NavegationListener.class, l);
    }

    public synchronized void removeNavegationListener(NavegationListener l) {
        this.listenerList.remove(NavegationListener.class, l);
    }

    public synchronized void addDescriptionListener(DescriptionListener l) {
        this.addListener(DescriptionListener.class, l);
    }

    public synchronized void removeDescriptionListener(DescriptionListener l) {
        this.listenerList.remove(DescriptionListener.class, l);
    }

    private synchronized <T extends EventListener> void addListener(Class<T> t, T l) {
        boolean exist = false;
        for (EventListener listener : this.listenerList.getListeners(t)) {
            if (!listener.equals(l)) continue;
            exist = true;
        }
        if (!exist) {
            this.listenerList.add(t, l);
        }
    }

    public void fireValidityEvent(boolean valid) {
        Object[] listeners = this.listenerList.getListenerList();
        ConversionEvent e = new ConversionEvent(this.command != null ? this.command : "", valid);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ValidityListener.class) continue;
            ((ValidityListener)listeners[i + 1]).validityActionPerformed(e);
        }
    }

    public void fireNavegationEvent(String where) {
        Object[] listeners = this.listenerList.getListenerList();
        ConversionEvent e = new ConversionEvent(where, true);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != NavegationListener.class) continue;
            ((NavegationListener)listeners[i + 1]).navegationActionPerformed(e);
        }
    }

    public void fireDescriptionEvent(String name, boolean focusIn) {
        if (name == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        ConversionEvent e = new ConversionEvent(name, focusIn);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DescriptionListener.class) continue;
            ((DescriptionListener)listeners[i + 1]).descriptionActionPerformed(e);
        }
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean valid) {
        if (valid != this.isValid) {
            this.isValid = valid;
            this.fireValidityEvent(this.isValid);
        }
    }

    @Override
    public void validityActionPerformed(ConversionEvent e) {
        this.setValid(e.getValue());
    }

    @Override
    public Object getData() {
        return null;
    }

    @Override
    public void setData(Object obj) {
    }

    @Override
    public String getName() {
        return this.componentName;
    }

    @Override
    public DataRetrievable.DataType getDataType() {
        return null;
    }

    @Override
    public String getGroupName() {
        if (this.componentGroup != null) {
            return this.componentGroup;
        }
        return "";
    }

    @Override
    public void setActive(Boolean b) {
        this.isActive = b;
    }

    @Override
    public void addValueChangedAction(Actionable action) {
        this.valueChangedActionsList.add(action);
    }

    protected void valueChanged() {
        for (Actionable action : this.valueChangedActionsList) {
            action.act();
        }
    }

    @Override
    public void setError(Boolean b, String Message2) {
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }
}

