/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.api;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.scriptelement.CtmBaseEntity;
import com.bmc.ctmconvert.scriptelement.FromJob;
import com.bmc.ctmconvert.scriptelement.TimeUnit;
import com.bmc.ctmconvert.scriptelement.ToTime;
import com.bmc.ctmconvert.workspace.entities.IRBC;
import com.bmc.ctmconvert.workspace.entities.RbcAPI;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class SchedulingAPI {
    private final CtmBaseEntity entity;

    public SchedulingAPI(CtmBaseEntity entity) {
        this.entity = entity;
    }

    public void addControlmLevelRuleBasedCalendar(String calendarName) {
        RbcAPI rbc = RbcAPI.createEmptyRBC(calendarName).setControlMLevel();
        this.entity.addRBC(rbc);
    }

    public void addRBC(IRBC rbc) {
        if (rbc != null) {
            this.entity.addRBC(rbc);
        }
    }

    public void useSchedulingFromParentFolder() {
        this.useSpecificRuleBasedCalendar("*");
    }

    public void useSpecificRuleBasedCalendar(String calendarName) {
        this.entity.addRBC(RbcAPI.createJobRBC(calendarName));
    }

    public List<IRBC> getRBCsList() {
        return this.entity.getRBCs();
    }

    public void setTimeSettings(String fromTime, String toTime) {
        this.entity.addAttribute("TIMEFROM", fromTime);
        this.entity.addAttribute("TIMETO", toTime);
    }

    public void setTimeSettingsEndOfDay(String fromTime) {
        this.setTimeSettings(fromTime, "");
    }

    public void setTimeSettings(String fromTime, ToTime toTime) {
        switch (toTime) {
            case EndOfDay: {
                this.entity.addAttribute("TIMEFROM", fromTime);
                this.entity.addAttribute("TIMETO", "");
                break;
            }
            case PastNewDay: {
                this.entity.addAttribute("TIMEFROM", fromTime);
                this.entity.addAttribute("TIMETO", ">");
                break;
            }
        }
    }

    public void setTimeSettingsAllow(String fromTime) {
        this.setTimeSettings(fromTime, ">");
    }

    public void setMaxReruns(int maxReruns) {
        this.entity.addAttribute("MAXRERUN", String.valueOf(maxReruns));
    }

    public void enableCyclic() {
        this.entity.addAttribute("CYCLIC", "1");
    }

    public void disableCyclic() {
        this.entity.addAttribute("CYCLIC", "0");
    }

    public RerunIntervalAPI rerunInterval() {
        return new RerunIntervalAPI(this, this.entity);
    }

    public void setWeekDays(String weekdays) {
        this.entity.addAttribute("WEEKDAYS", weekdays);
    }

    public void setDays(String days) {
        this.entity.addAttribute("DAYS", days);
    }

    public void setSchedulingTypeEveryDay() {
        this.resetSchedulingAttributes();
        this.setDays("ALL");
    }

    public void setSchedulingTypeWeekDays() {
        this.setDays("");
    }

    private void resetSchedulingAttributes() {
        this.setDays("");
        this.setWeekDays("");
    }

    private void setAllMonthsTo(String value) {
        this.monthsStream().forEach(month -> this.entity.addAttribute((String)month, value));
    }

    private Stream<String> monthsStream() {
        return Arrays.stream(GlobalFunctions.getMonthsArray());
    }

    public void setSchedulingTypeNone() {
        this.resetSchedulingAttributes();
    }

    public void setOrderOnMonthsAll() {
        this.setAllMonthsTo("1");
    }

    public void setOrderOnMonthsNone() {
        this.setAllMonthsTo("0");
    }

    public void enableOrderOnMonth(int monthIndexZeroBased) {
        this.entity.addAttribute(GlobalFunctions.getMonthsArray()[monthIndexZeroBased], "1");
    }

    public void disableOrderOnMonth(int monthIndexZeroBased) {
        this.entity.addAttribute(GlobalFunctions.getMonthsArray()[monthIndexZeroBased], "0");
    }

    public void setRerunInterval(int timeInterval, TimeUnit timeUnit) {
        this.entity.addAttribute("INTERVAL", String.format("%05d%c", timeInterval, Character.valueOf(timeUnit.toChar())));
    }

    public void restartFromJobs(FromJob fromJob) {
        this.entity.addAttribute("IND_CYCLIC", fromJob.toString());
    }

    public class RerunIntervalAPI {
        private CtmBaseEntity entity;

        public RerunIntervalAPI(SchedulingAPI this$0, CtmBaseEntity entity) {
            this.entity = entity;
        }

        private void setRerunBy(int amount, char units) {
            this.entity.addAttribute("INTERVAL", String.format("%05d%c", amount, Character.valueOf(units)));
        }

        public void setRerunByDays(int days) {
            this.setRerunBy(days, 'D');
        }

        public void setRerunByHours(int hours) {
            this.setRerunBy(hours, 'H');
        }

        public void setRerunByMinutes(int minutes) {
            this.setRerunBy(minutes, 'M');
        }

        public void setIntervalsAreFromJobsStart() {
            this.entity.addAttribute("IND_CYCLIC", "S");
        }

        public void setIntervalsAreFromJobsEnd() {
            this.entity.addAttribute("IND_CYCLIC", "E");
        }

        public void setIntervalsAreFromJobsTarget() {
            this.entity.addAttribute("IND_CYCLIC", "T");
        }
    }
}

