/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.api;

import com.bmc.ctmconvert.api.SapR3AbapStepAPI;
import com.bmc.ctmconvert.scriptelement.CtmBaseEntity;

public class SapR3StepAPI {
    private final CtmBaseEntity entity;
    private final int stepCount;

    public SapR3StepAPI setUser(String user) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-OWNER", user);
        return this;
    }

    public String getUser() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-OWNER");
    }

    public SapR3StepAPI setProgramName(String abapProgramName) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-PROGRAM", abapProgramName);
        return this;
    }

    public String getProgramName() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-PROGRAM");
    }

    public SapR3StepAPI logExternalErrorsToJobLog(boolean value) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-LOG_STDERR", CheckBoxStatus.fromBoolean(value));
        return this;
    }

    public SapR3StepAPI logExternalOutputToJobLog(boolean value) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-LOG_STDOUT", CheckBoxStatus.fromBoolean(value));
        return this;
    }

    public SapR3StepAPI activateTrace(boolean value) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-ACTIVATE_TRACE", CheckBoxStatus.fromBoolean(value));
        return this;
    }

    public SapR3StepAPI jobWaitingForExternalTermination(boolean value) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-WAIT_FOR_TERM", CheckBoxStatus.fromBoolean(value));
        return this;
    }

    public SapR3StepAPI setVariableType(SapR3AbapStepAPI.VariantType type) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-VAR_TYPE", type.toString());
        return this;
    }

    public SapR3StepAPI setTargetHost(String host) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-TARGET_HOST", host);
        return this;
    }

    public SapR3StepAPI setVariantName(String value) {
        this.setVariable("%%%%SAPR3-STEP-S%02d-VAR-NAME", value);
        this.setVariableType(SapR3AbapStepAPI.VariantType.Regular);
        return this;
    }

    public String getVariantName() {
        return this.getVariableValue("%%%%SAPR3-STEP-S%02d-VAR-NAME");
    }

    public SapR3StepAPI(CtmBaseEntity entity, int stepCount) {
        this.entity = entity;
        this.stepCount = stepCount;
    }

    protected void setVariable(String variableFormat, String variableValue) {
        this.entity.setVariable(String.format(variableFormat, this.stepCount), variableValue);
    }

    protected String getVariableValue(String variableFormat) {
        return this.entity.getVariableByName(String.format(variableFormat, this.stepCount));
    }

    static enum CheckBoxStatus {
        Selected("X"),
        NotSelected("N");

        private final String value;

        private CheckBoxStatus(String value) {
            this.value = value;
        }

        public static String fromBoolean(boolean value) {
            if (value) {
                return "X";
            }
            return "N";
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ProgramType {
        ABAP("A"),
        ExternalCommand("C"),
        ExternalProgram("E");

        private final String value;

        private ProgramType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

