/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.api;

import com.bmc.ctmconvert.api.SapR3AbapStepAPI;
import com.bmc.ctmconvert.api.SapR3ExternalCommandStepApi;
import com.bmc.ctmconvert.api.SapR3ExternalProgramStepApi;
import com.bmc.ctmconvert.scriptelement.CtmBaseEntity;
import com.bmc.ctmconvert.scriptelement.CtmJob;
import com.bmc.ctmconvert.scriptelement.SapR3Action;
import com.bmc.ctmconvert.scriptelement.SapR3ExecTarget;
import com.bmc.ctmconvert.scriptelement.SapR3JobClass;
import org.jetbrains.annotations.NotNull;

public class SapR3ParametersAPI {
    private final CtmBaseEntity entity;

    public SapR3ParametersAPI(CtmBaseEntity entity) {
        this.entity = entity;
    }

    public void setConnectionProfile(String connectionProfile) {
        this.entity.setVariable("%%SAPR3-ACCOUNT", connectionProfile);
    }

    public void deleteAll() {
        this.entity.getVariables().forEach(item -> {
            if (item.getName().startsWith("%%SAPR3")) {
                this.entity.removeVariable(item.getName());
            }
        });
    }

    public void setSAPJobName(String sapJobName) {
        this.entity.setVariable("%%SAPR3-JOBNAME", sapJobName);
    }

    public void setJobClass(SapR3JobClass jobClass) {
        this.entity.setVariable("%%SAPR3-JOBCLASS", jobClass.toString());
    }

    public void setExececutionTarget(SapR3ExecTarget type, String execTarget) {
        this.entity.setVariable("%%SAPR3-SERVER_OR_GROUP_TYPE", type.toString());
        this.entity.setVariable("%%SAPR3-TARGET_SERVER", execTarget);
    }

    public void setSpoolName() {
        this.entity.setVariable("%%SAPR3-SPOOL", "*SYSOUT");
    }

    public void setStartCondition(String value) {
        this.entity.setVariable("%%SAPR3-SUBMIT_ASAP", value);
    }

    public void setEventID(String value) {
        this.entity.setVariable("%%SAPR3-EVENT_ID", value);
    }

    public void setProfileID(String value) {
        this.entity.setVariable("%%SAPR3-MANAGE_SAP_PROFILE_ID", value);
    }

    public void setAction(SapR3Action action) {
        this.entity.setVariable("%%SAPR3-JOB_MODE", action.toString());
    }

    public void setCopyJobCount(String value) {
        this.entity.setVariable("%%SAPR3-JOBCOUNT", value);
        this.entity.setVariable("%%SAPR3-JOB_COUNT", value);
    }

    public void setCopyNewJobName(String value) {
        this.entity.setVariable("%%SAPR3-JOB_COPY_TARGET_VAL", value);
    }

    public SapR3AbapStepAPI addAbapStep() {
        int stepCount = this.getStepCount();
        return new SapR3AbapStepAPI(this.entity, stepCount);
    }

    public SapR3ExternalProgramStepApi addExternalProgramStep(String name) {
        int stepCount = this.getStepCount();
        return new SapR3ExternalProgramStepApi(this.entity, stepCount, name);
    }

    @NotNull
    public SapR3ExternalCommandStepApi addExternalCommandStep(String externalCommandName) {
        int stepCount = this.getStepCount();
        return new SapR3ExternalCommandStepApi(this.entity, stepCount, externalCommandName);
    }

    public SapR3ExternalCommandStepApi externalCommandAPI(int stepCount) {
        return new SapR3ExternalCommandStepApi(this.entity, stepCount);
    }

    private int getStepCount() {
        ((CtmJob)this.entity).incrementSapStepsCounter();
        return ((CtmJob)this.entity).getSapStepsCounter();
    }
}

