/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.api;

import com.bmc.ctmconvert.api.CtmTransfer;
import com.bmc.ctmconvert.scriptelement.CtmBaseEntity;
import com.bmc.ctmconvert.scriptelement.CtmJob;
import java.util.HashMap;
import java.util.Map;

public class FileTransferParametersAPI {
    private CtmBaseEntity entity;
    private Map<Integer, CtmTransfer> ctmTransferMap = new HashMap<Integer, CtmTransfer>();

    public FileTransferParametersAPI(CtmBaseEntity entity) {
        this.entity = entity;
        this.initDefaults();
    }

    private void initDefaults() {
        this.entity.setVariable("%%FTP-RPF", "0");
    }

    public void setConnectionProfile(String connectionProfile) {
        this.entity.setVariable("%%FTP-ACCOUNT", connectionProfile);
    }

    public void setRerunFromPointOfFailure() {
        this.entity.setVariable("%%FTP-RPF", "1");
    }

    public CtmTransfer addNewTransfer() {
        ((CtmJob)this.entity).incrementFileTransferCounter();
        int transferCount = ((CtmJob)this.entity).getFileTransferCounter();
        this.entity.setVariable("%%FTP-TRANSFER_NUM", String.format("%01d", transferCount));
        CtmTransfer ctmTransfer = new CtmTransfer(this.entity, transferCount);
        this.ctmTransferMap.put(transferCount, ctmTransfer);
        return ctmTransfer;
    }

    public CtmTransfer getCtmTransfer(Integer transferCount) {
        CtmTransfer ctmTransfer = this.ctmTransferMap.get(transferCount);
        return ctmTransfer;
    }
}

