/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import javax.swing.JProgressBar;

public class S3Downloader {
    public static final int HTTP_OK_CODE = 200;

    public boolean download(String url, OutputStream outputStream) throws URISyntaxException, IOException, InterruptedException {
        HttpResponse<InputStream> response = this.getInputStreamHttpResponse(url);
        if (response.statusCode() == 200) {
            response.body().transferTo(outputStream);
            return true;
        }
        return false;
    }

    public boolean downloadWithProgressPar(String url, OutputStream outputStream, JProgressBar progressBar) throws IOException, URISyntaxException, InterruptedException {
        HttpResponse<InputStream> response = this.getInputStreamHttpResponse(url);
        if (response.statusCode() == 200) {
            progressBar.setValue(50);
            response.body().transferTo(outputStream);
            progressBar.setValue(100);
            return true;
        }
        return false;
    }

    private HttpResponse<InputStream> getInputStreamHttpResponse(String url) throws URISyntaxException, IOException, InterruptedException {
        HttpRequest request2 = HttpRequest.newBuilder().uri(new URI(url)).GET().build();
        return HttpClient.newBuilder().build().send(request2, HttpResponse.BodyHandlers.ofInputStream());
    }
}

