/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.connect_direct.reader;

import com.bmc.ctmconvert.common.ExceptionHandler;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CDFileHandler {
    private BufferedReader br;
    private StringBuilder content;

    public CDFileHandler(String path, int limitedContentSize) {
        try {
            FileInputStream inputStream = new FileInputStream(path);
            this.content = this.getFileContent(limitedContentSize, inputStream);
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public CDFileHandler(InputStream inputStream, int limitedContentSize) {
        this.content = this.getFileContent(limitedContentSize, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder getFileContent(int limitedContentSize, InputStream inputStream) {
        StringBuilder fileContent = new StringBuilder();
        try {
            this.br = new BufferedReader(new InputStreamReader(inputStream));
            int NO_CONTENT_LIMIT = 0;
            fileContent = limitedContentSize > NO_CONTENT_LIMIT ? this.getFileContentForAssessmentReport(limitedContentSize) : this.getFileContentForConversionProcess();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        finally {
            try {
                this.br.close();
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
        return fileContent;
    }

    public StringBuilder getContent() {
        return this.content;
    }

    private StringBuilder getFileContentForAssessmentReport(int limitedContentSize) throws IOException {
        StringBuilder fileContent = new StringBuilder();
        char[] bufferToWriteTo = new char[limitedContentSize];
        this.br.read(bufferToWriteTo, 0, bufferToWriteTo.length);
        for (char x : bufferToWriteTo) {
            fileContent.append(x);
        }
        return fileContent;
    }

    private StringBuilder getFileContentForConversionProcess() throws IOException {
        String currentLine;
        StringBuilder fileContent = new StringBuilder();
        while ((currentLine = this.br.readLine()) != null) {
            fileContent.append(currentLine);
            fileContent.append("\n");
        }
        return fileContent;
    }
}

