/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.connect_direct.data;

import com.bmc.ctmconvert.connect_direct.data.ErrorData;
import com.bmc.ctmconvert.dataObject.AbstractData;
import com.bmc.ctmconvert.dataObject.IAttribute;
import com.bmc.ctmconvert.dataObject.entities.Attribute;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;

public class ErrorDataParseError
extends AbstractData
implements ErrorData {
    private ErrorData.ErrorType errorType;
    private String processFullPathFileName = "";

    public ErrorDataParseError(String processFullPathFileName) {
        this.setErrorType(ErrorData.ErrorType.PARSE_ERROR);
        this.setProcessFullPathFileName(processFullPathFileName);
        this.setProcessName();
    }

    private void setErrorType(ErrorData.ErrorType errorType) {
        this.errorType = errorType;
        this.add((IAttribute)Attribute.from((String)"ERROR_TYPE", (String)this.errorType.toString()));
    }

    @Override
    public ErrorData.ErrorType getErrorType() {
        return this.errorType;
    }

    private void setProcessFullPathFileName(String data) {
        this.processFullPathFileName = data;
        this.add((IAttribute)Attribute.from((String)"PROCESS_FULL_PATH_FILE_NAME", (String)this.processFullPathFileName));
    }

    private void setProcessName() {
        this.add((IAttribute)Attribute.from((String)"process_file_name", (String)this.getFileName()));
    }

    @Override
    public String getErrorMessage() {
        String messageFormat = "";
        messageFormat = "Process file name - '%s'";
        return String.format(messageFormat, this.processFullPathFileName);
    }

    public String getProcessFullPathFileName() {
        return this.processFullPathFileName;
    }

    public String getFileName() {
        try {
            return Paths.get(this.processFullPathFileName, new String[0]).getFileName().toString();
        }
        catch (InvalidPathException e) {
            return "Not a file";
        }
    }

    @Override
    public String getDataType() {
        return "ERROR";
    }
}

